@echo off

rem -------------------------------------------------------------------------------
rem Check parameter
if [%1] == [] goto Usage
if [%2] == [] goto Usage

rem -------------------------------------------------------------------------------
rem Script start
echo Preparing output directory...

rem -------------------------------------------------------------------------------
rem Set directory variables

set TOP_SRC_DIR=%1

set RES_DIR=%1res
echo Resources directory: %RES_DIR%

set IMAGES_DIR=%1images
echo Images directory: %IMAGES_DIR%

set EXT_LIB_DIR=%1..\mysql-gui-win-res\lib
echo Windows resource directory: %EXT_LIB_DIR%

set EXT_BIN_DIR=%1..\mysql-gui-win-res\bin
echo External binary directory: %EXT_BIN_DIR%


set TARGET_DIR=%1bin\%2
echo Target directory: %TARGET_DIR%

set FONTS_DIR=%1res\fonts
echo Fonts directory: %FONTS_DIR%

set PYTHON_SRC_DIR=%1..\mysql-gui-win-res\python26\
echo Python directory: %PYTHON_SRC_DIR%

rem -------------------------------------------------------------------------------
rem Copy the files to the target directory

echo Copy Struct files ...
if not exist %TARGET_DIR%\structs mkdir %TARGET_DIR%\structs
xcopy /i /s /y /d %RES_DIR%\grt\structs*.xml %TARGET_DIR%\structs\. 1> nul 2> nul

echo Copy image files ...
if not exist %TARGET_DIR%\images\grt\structs mkdir %TARGET_DIR%\images\grt\structs
if not exist %TARGET_DIR%\images\icons mkdir %TARGET_DIR%\images\icons
if not exist %TARGET_DIR%\images\cursors mkdir %TARGET_DIR%\images\cursors
if not exist %TARGET_DIR%\images\ui mkdir %TARGET_DIR%\images\ui
if not exist %TARGET_DIR%\images\home mkdir %TARGET_DIR%\images\home
xcopy /i /s /y /d %IMAGES_DIR%\grt\*.png %TARGET_DIR%\images\grt\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\grt\structs\*.png %TARGET_DIR%\images\grt\structs\. 1> nul 2> nul
xcopy /i /y /d %IMAGES_DIR%\icons\*.png %TARGET_DIR%\images\icons\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\icons\MySQLWorkbench.ico %TARGET_DIR%\images\icons\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\toolbar\*.png %TARGET_DIR%\images\icons\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\changeset\*.png %TARGET_DIR%\images\icons\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\admin\*.png %TARGET_DIR%\images\icons\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\cursors\*.cur %TARGET_DIR%\images\cursors\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\icons\MySQLWorkbenchDoc.ico %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\ui\*.png %TARGET_DIR%\images\ui\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\ui\*.xpm %TARGET_DIR%\images\ui\. 1> nul 2> nul
xcopy /i /s /y /d %IMAGES_DIR%\home\*.png %TARGET_DIR%\images\home\. 1> nul 2> nul

echo Copy Resource files ..
if not exist %TARGET_DIR%\data mkdir %TARGET_DIR%\data
xcopy /i /s /y /d %RES_DIR%\grtdata\*.xml %TARGET_DIR%\data\. 1> nul 2> nul
xcopy /i /s /y /d %RES_DIR%\wbdata\*.xml %TARGET_DIR%\data\. 1> nul 2> nul
xcopy /i /s /y /d %RES_DIR%\wbdata\data.db %TARGET_DIR%\data\. 1> nul 2> nul

if not exist %TARGET_DIR%\mysql.profiles mkdir %TARGET_DIR%\mysql.profiles
copy %RES_DIR%\mysql.profiles\*.xml %TARGET_DIR%\mysql.profiles\. 1> nul 2> nul

if not exist %TARGET_DIR%\snippets mkdir %TARGET_DIR%\snippets
copy %RES_DIR%\snippets\*.txt %TARGET_DIR%\snippets\. 1> nul 2> nul

echo Copy Scripting Libraries...
xcopy /i /s /y /d %RES_DIR%\scripts\lua\*.lua %TARGET_DIR%\
xcopy /i /s /y /d %RES_DIR%\scripts\python\*.py %TARGET_DIR%\
xcopy /i /s /y /d %RES_DIR%\scripts\snippets\shell_snippets.* %TARGET_DIR%\
xcopy /i /s /y /d %TOP_SRC_DIR%\library\sshtunnel\sshtunnel.py %TARGET_DIR%\
xcopy /i /s /y /d %RES_DIR%\scripts\shell\*.vbs %TARGET_DIR%\

echo Copy python/mforms
xcopy /i /s /y /d %TOP_SRC_DIR%\library\forms\swig\mforms.py %TARGET_DIR%\

echo Copy libraries ...

xcopy /i /s /y /d %EXT_BIN_DIR%\mysqldump.exe %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_BIN_DIR%\mysql.exe %TARGET_DIR%\. 1> nul 2> nul

echo * MySQL client library ...
xcopy /i /s /y /d %EXT_LIB_DIR%\mysql\%2\libmysql.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\mysql\%2\libmysql.pdb %TARGET_DIR%\. 1> nul 2> nul

echo * MySQL cdbc driver ...
rem copy %EXT_LIB_DIR%\cppconn\mysql\%2\mysqlcppconn.dll %TARGET_DIR%\. 1> nul 2> nul

echo * glib libraries ...
xcopy /i /s /y /d %EXT_LIB_DIR%\glib-2.12\libglib-2.0-0.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\glib-2.12\libgmodule-2.0-0.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\glib-2.12\libgobject-2.0-0.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\glib-2.12\libgthread-2.0-0.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\glib-2.12\intl.dll %TARGET_DIR%\. 1> nul 2> nul

echo * libxml2 libraries ...
xcopy /i /s /y /d %EXT_LIB_DIR%\libxml\libxml2.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\libxml\iconv.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\libxml\zlib.dll %TARGET_DIR%\. 1> nul 2> nul

echo * zlib library ...
xcopy /i /s /y /d %EXT_LIB_DIR%\zlib\zlib1.dll %TARGET_DIR%\. 1> nul 2> nul

echo * python library ...
xcopy /i /s /y /d %EXT_LIB_DIR%"\python\%2\*.dll" %TARGET_DIR%\. 1> nul 2> nul

rem echo * sigc++ library ...
rem copy %EXT_LIB_DIR%"\sigc++\release\sigc-2.0.dll" %TARGET_DIR%\. 1> nul 2> nul
rem copy %EXT_LIB_DIR%"\sigc++\debug\sigc-2.0d.dll" %TARGET_DIR%\. 1> nul 2> nul

echo * lua library ...
xcopy /i /s /y /d %EXT_LIB_DIR%\lua-5.1.1\lua5.1.dll %TARGET_DIR%\. 1> nul 2> nul

echo * glut library ...
xcopy /i /s /y /d %EXT_LIB_DIR%\glut\glut32.dll %TARGET_DIR%\. 1> nul 2> nul

rem echo * glitz library ...
rem copy %EXT_LIB_DIR%\glitz\glitz.dll %TARGET_DIR%\. 1> nul 2> nul
rem copy %EXT_LIB_DIR%\glitz\glitz_mesa.dll %TARGET_DIR%\. 1> nul 2> nul

echo * cairo library ...
xcopy /i /s /y /d %EXT_LIB_DIR%\cairo\*.dll %TARGET_DIR%\. 1> nul 2> nul
rem copy %EXT_LIB_DIR%\cairo\libcairo_mesa.dll %TARGET_DIR%\. 1> nul 2> nul

rem echo * mesa library ...
rem not needed anymore since 5.0.14
rem copy %EXT_LIB_DIR%\mesa\mesa_glu32.dll %TARGET_DIR%\. 1> nul 2> nul
rem rem copy %EXT_LIB_DIR%\mesa\glut32.dll %TARGET_DIR%\. 1> nul 2> nul
rem copy %EXT_LIB_DIR%\mesa\mesa_opengl32.dll %TARGET_DIR%\. 1> nul 2> nul
rem copy %EXT_LIB_DIR%\mesa\mesa_osmesa32.dll %TARGET_DIR%\. 1> nul 2> nul

echo * png library ...
xcopy /i /s /y /d %EXT_LIB_DIR%\libpng\libpng12-0.dll %TARGET_DIR%\. 1> nul 2> nul

echo * curl library ...
xcopy /i /s /y /d %EXT_LIB_DIR%\curl\libcurl.dll %TARGET_DIR%\. 1> nul 2> nul

echo * MS VC runtime libraries ...
xcopy /i /s /y /d %EXT_LIB_DIR%\windows\cc3270.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\windows\cc3270mt.dll %TARGET_DIR%\. 1> nul 2> nul

copy %EXT_LIB_DIR%\windows\Microsoft.VC80.CRT.manifest %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\windows\Microsoft.VC80.DebugCRT.manifest %TARGET_DIR%\. 1> nul 2> nul

xcopy /i /s /y /d %EXT_LIB_DIR%\windows\msvcm80.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\windows\msvcm80d.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\windows\msvcp80.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\windows\msvcp80d.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\windows\msvcr80.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\windows\msvcr80d.dll %TARGET_DIR%\. 1> nul 2> nul

xcopy /i /s /y /d %EXT_LIB_DIR%\windows\Microsoft.VC90.CRT.manifest %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\windows\msvcm90.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\windows\msvcp90.dll %TARGET_DIR%\. 1> nul 2> nul
xcopy /i /s /y /d %EXT_LIB_DIR%\windows\msvcr90.dll %TARGET_DIR%\. 1> nul 2> nul

rem copy msvcr71.dll (python dep)
xcopy /i /s /y /d %EXT_LIB_DIR%\windows\msvcr71.dll %TARGET_DIR%\. 1> nul 2> nul

rem workaround for manifest issue

rem copy %EXT_LIB_DIR%\windows\Microsoft.VC80.CRT.manifest %TARGET_DIR%\mysql.canvas\. 1> nul 2> nul
rem copy %EXT_LIB_DIR%\windows\Microsoft.VC80.CRT.manifest %TARGET_DIR%\mysql.canvas.mesa\. 1> nul 2> nul

rem copy %EXT_LIB_DIR%\windows\msvcm80.dll %TARGET_DIR%\mysql.canvas\. 1> nul 2> nul
rem copy %EXT_LIB_DIR%\windows\msvcp80.dll %TARGET_DIR%\mysql.canvas\. 1> nul 2> nul
rem copy %EXT_LIB_DIR%\windows\msvcr80.dll %TARGET_DIR%\mysql.canvas\. 1> nul 2> nul
rem copy %EXT_LIB_DIR%\windows\msvcm80.dll %TARGET_DIR%\mysql.canvas.mesa\. 1> nul 2> nul
rem copy %EXT_LIB_DIR%\windows\msvcp80.dll %TARGET_DIR%\mysql.canvas.mesa\. 1> nul 2> nul
rem copy %EXT_LIB_DIR%\windows\msvcr80.dll %TARGET_DIR%\mysql.canvas.mesa\. 1> nul 2> nul

rem end of workaround for manifest issue

rem echo * ctemplate library ...
rem copy %EXT_LIB_DIR%\ctemplate\%2\libctemplate.dll %TARGET_DIR%\. 1> nul 2> nul

echo * scintilla library ...
xcopy /i /s /y /d %EXT_LIB_DIR%\scintilla\SciLexer.dll %TARGET_DIR%\. 1> nul 2> nul

rem copy fonts
if not exist %TARGET_DIR%\fonts mkdir %TARGET_DIR%\fonts
xcopy /i /s /y /d %FONTS_DIR%\*.* %TARGET_DIR%\fonts

if not exist %TARGET_DIR%\modules\data\sqlide mkdir %TARGET_DIR%\modules\data\sqlide
xcopy /i /s /y /d %RES_DIR%\sqlidedata\templates\*.* %TARGET_DIR%\modules\data\sqlide\. 1> nul 2> nul

echo * Python libraries
if not exist %TARGET_DIR%\python mkdir %TARGET_DIR%\python 1> nul 2> nul
xcopy /i /y /d %PYTHON_SRC_DIR%\lib\*.py %TARGET_DIR%\python 1> nul 2> nul

xcopy /i /s /y /d %PYTHON_SRC_DIR%\%2 %TARGET_DIR% 1> nul 2> nul

xcopy /i /s /y /d %PYTHON_SRC_DIR%\lib\encodings %TARGET_DIR%\python\encodings 1> nul 2> nul
xcopy /i /s /y /d %PYTHON_SRC_DIR%\lib\logging %TARGET_DIR%\python\logging 1> nul 2> nul
xcopy /i /s /y /d %PYTHON_SRC_DIR%\lib\site-packages %TARGET_DIR%\python\site-packages 1> nul 2> nul
xcopy /i /s /y /d %PYTHON_SRC_DIR%\lib\ctypes %TARGET_DIR%\python\ctypes 1> nul 2> nul

rem copy %PYTHON_SRC_DIR%\lib\new.py %TARGET_DIR%\python 1> nul 2> nul
rem copy %PYTHON_SRC_DIR%\lib\types.py %TARGET_DIR%\python 1> nul 2> nul
rem copy %PYTHON_SRC_DIR%\lib\platform.py %TARGET_DIR%\python 1> nul 2> nul
rem copy %PYTHON_SRC_DIR%\lib\string.py %TARGET_DIR%\python 1> nul 2> nul
rem copy %PYTHON_SRC_DIR%\lib\re.py %TARGET_DIR%\python 1> nul 2> nul
rem copy %PYTHON_SRC_DIR%\lib\sre_*.py %TARGET_DIR%\python 1> nul 2> nul
rem copy %PYTHON_SRC_DIR%\lib\copy_reg.py %TARGET_DIR%\python 1> nul 2> nul
rem copy %PYTHON_SRC_DIR%\lib\os.py %TARGET_DIR%\python 1> nul 2> nul
rem copy %PYTHON_SRC_DIR%\lib\ntpath.py %TARGET_DIR%\python 1> nul 2> nul
rem copy %PYTHON_SRC_DIR%\lib\stat.py %TARGET_DIR%\python 1> nul 2> nul
rem copy %PYTHON_SRC_DIR%\lib\UserDict.py %TARGET_DIR%\python 1> nul 2> nul
rem copy %PYTHON_SRC_DIR%\lib\SubProcess.py %TARGET_DIR%\python 1> nul 2> nul
rem copy %PYTHON_SRC_DIR%\lib\traceback.py %TARGET_DIR%\python 1> nul 2> nul
rem copy %PYTHON_SRC_DIR%\lib\linecache.py %TARGET_DIR%\python 1> nul 2> nul
rem copy %PYTHON_SRC_DIR%\lib\threading.py %TARGET_DIR%\python 1> nul 2> nul
rem copy %PYTHON_SRC_DIR%\lib\named_pexpect.py %TARGET_DIR%\python 1> nul 2> nul
rem copy %PYTHON_SRC_DIR%\lib\tempfile.py %TARGET_DIR%\python 1> nul 2> nul
rem copy %PYTHON_SRC_DIR%\lib\random.py %TARGET_DIR%\python 1> nul 2> nul
rem copy %PYTHON_SRC_DIR%\lib\warnings.py %TARGET_DIR%\python 1> nul 2> nul

rem -------------------------------------------------------------------------------
rem Call sub-scripts

call %1\modules\PrepareOutputDir.cmd %1 %2

rem -------------------------------------------------------------------------------
rem Work is done
echo Output directory preparation complete.

rem Make sure to reset error level
set ERRORLEVEL=0

goto EndOfScript

:Usage

echo This script sets up the output directory so that applications can be started from there and find
echo all directories and files as in the final distribution. The script takes 3 parameters, the 
echo SolutionDirectory, ConfigurationName and the WbOut output directory
echo .
echo Usage: 
echo   %0 SolutionDirectory ConfigurationName
echo .
echo Example:
echo   %0 "C:\Documents and Settings\mysqldev\My Documents\work\mysql-workbench-pro" Debug
echo .

:EndOfScript
