/*
 *  wb_physical_model_diagram_features.h
 *  MySQLWorkbench
 *
 *  Created by Alfredo Kojima on 14/Mar/09.
 *  Copyright 2009 Sun Microsystems Inc. All rights reserved.
 *
 */

#ifndef _WB_PHYSICAL_MODEL_DIAGRAM_FEATURES_H_
#define _WB_PHYSICAL_MODEL_DIAGRAM_FEATURES_H_

#include <mdc.h>
#include <grts/structs.model.h>
#include <grts/structs.workbench.physical.h>

#include "grt/grt_manager.h"

namespace wb {
  
  class ModelDiagramForm;
  class Tooltip;
  
  /** Implementation of diagram manipulation goodies (basic stuff is in wb_model_diagram_form)
   */
  class PhysicalModelDiagramFeatures : public sigc::trackable
  {
    ModelDiagramForm *_diagram;
    mdc::Timestamp _last_click;
    mdc::Point _last_click_pos;

    mdc::CanvasItem *_last_over_item;
    Tooltip *_tooltip;
    bec::GRTManager::Timer *_tooltip_timer;
    
    std::string _highlighted_table_id;
    
    void on_figure_click(const model_ObjectRef &owner, mdc::CanvasItem *item, const mdc::Point &pos, mdc::MouseButton button, mdc::EventState state);
    void on_figure_mouse_button(const model_ObjectRef &owner, mdc::CanvasItem *item, bool press, const mdc::Point &pos, mdc::MouseButton button, mdc::EventState state);
    void on_figure_crossed(const model_ObjectRef &owner, mdc::CanvasItem *item, bool enter, const mdc::Point &pos);

    void on_selection_changed();
    
    
    void activate_item(const model_ObjectRef &owner, mdc::CanvasItem *item, mdc::EventState state);
    
    void highlight_connection(const workbench_physical_ConnectionRef &conn, bool flag);
    void highlight_table(const workbench_physical_TableFigureRef &table, bool flag);
    void highlight_table_index(const workbench_physical_TableFigureRef &table,
                               const db_IndexRef &index, bool entered);
    
    void tooltip_setup(const model_ObjectRef &owner);
    void tooltip_cancel();
    void show_tooltip(const model_ObjectRef &owner, mdc::CanvasItem *item);
    
    mdc::CanvasView *get_canvas_view();
    bec::GRTManager::Timer *run_every(const sigc::slot<bool> &slot, double seconds);
    void cancel_timer(bec::GRTManager::Timer *timer);
    
  public:
    PhysicalModelDiagramFeatures(ModelDiagramForm *diagram);
    virtual ~PhysicalModelDiagramFeatures();
        
    virtual void mouse_moved(int x, int y, mdc::EventState state);
    
//    virtual bool key_pressed();
  };
  
};

#endif
