/* 
 * Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA 02110-1301  USA
 */


#ifndef _RECORDSET_EXPORT_FORM_H_
#define _RECORDSET_EXPORT_FORM_H_

#include <mforms/mforms.h>

//#include "workbench/wb_context_ui.h"
#include "workbench/wb_backend_public_interface.h"
#include "sqlide/recordset_be.h"

class Db_sql_editor;

class MYSQLWBBACKEND_PUBLIC_FUNC RecordsetExportForm : public mforms::Form 
{
public:
  RecordsetExportForm(Db_sql_editor *editor, Recordset::Ref rset=Recordset::Ref());
  
  void run();
  
private:
  Db_sql_editor *_editor;
  Recordset::Ref _rset;

  mforms::Box _vbox;
  mforms::Table _table;

  mforms::Label _res_label;
  mforms::Selector _res_sel;
  mforms::Label _type_label;
  mforms::Selector _type_sel;
  mforms::Box _path_box;
  mforms::Label _path_label;
  mforms::TextEntry _path_text;
  mforms::Button _path_button;
  
  mforms::Box _button_box;
  mforms::Button _ok_button;
  mforms::Button _cancel_button;
  
  std::vector<std::string> _format_names;
  std::vector<std::string> _format_exts;
  
  std::string add_extension(const std::string &path);
  void change_type();
  void browse_path();
};


#endif
