/* 
 * Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WBCONTEXT_SQLIDE_H_
#define _WBCONTEXT_SQLIDE_H_

#include "workbench/wb_backend_public_interface.h"
#include "grt/grt_manager.h"
#include "grts/structs.db.mgmt.h"
#include "grts/structs.app.h"
#include "dialogs/search_replace.h"
#include <boost/weak_ptr.hpp>

class Db_sql_editor;

// Central point of management for SQLIDE (sql editor)
namespace wb 
{
  class WBContextUI;
  
  class MYSQLWBBACKEND_PUBLIC_FUNC WBContextSQLIDE
  {
    WBContextUI *_wbui;
    std::list<boost::weak_ptr<Db_sql_editor> > _open_editors;

  public:
    WBContextSQLIDE(WBContextUI *wbui);
    ~WBContextSQLIDE();
    void init();
    
    boost::shared_ptr<Db_sql_editor> create_connected_editor(const db_mgmt_ConnectionRef &conn);

    grt::ListRef<app_ToolbarItem> get_toolbar_items(const std::string &name);

    WBContextUI *get_wbui() { return _wbui; }
    bec::GRTManager *get_grt_manager();
    
    Db_sql_editor* get_active_sql_editor();

    bool activate_live_object(GrtObjectRef object);
    bool create_live_object(GrtObjectRef object_type, std::string owner_name, std::string obj_name);
    bool drop_live_object(GrtObjectRef object_type, std::string owner_name, std::string obj_name);

    void open_document(const std::string &path);
    
    bool request_quit();
    
    void editor_will_close(Db_sql_editor*); // to be called by Db_sql_editor

  public:
    void update_plugin_arguments_pool(bec::ArgumentPool &args);

    db_query_EditorRef get_grt_editor_object(Db_sql_editor *editor);
  private:
    void active_form_changed(bec::UIForm *form);
  };
};
                      
#endif
