#ifndef _WB_OVERVIEW_LIVE_PHYSICAL_H_
#define _WB_OVERVIEW_LIVE_PHYSICAL_H_

#include "workbench/wb_overview.h"
#include "sqlide/wb_live_schema_tree.h"
#include "model/wb_overview_physical.h"

namespace wb
{
  namespace internal
  {
    class LivePhysicalSchemataNode : public PhysicalSchemataNode
    {
      virtual OverviewBE::Node * create_child_node(db_SchemaRef schema);

      virtual bool add_object(WBContext *wb);
      virtual void delete_object(WBContext *wb);

    public:
      LivePhysicalSchemataNode(workbench_physical_ModelRef model);
    };
  };


  //
  // Node Layout:
  //
  // -root: ORoot  (model)   (stable nodeid)
  //   -schemata: ODivision     (stable nodeid) <RefreshChildren>
  //     -[schema]: OGroup   (kind of stable by oid*)  <RefreshNode>
  //       -table: OSection (stable for parent)   <RefreshChildren>
  //         -[table nodes]: OItem      <RefreshNode>
  //       -view: OSection (stable for parent)    <RefreshChildren>
  //         -[view nodes]: OItem       <RefreshNode>
  //       -routine: OSection (stable for parent) <RefreshChildren>
  //         -[routine nodes]: OItem    <RefreshNode>
  //       -routineGroup: OSection (stable for parent)<RefreshChildren>
  //         -[routineGroup nodes]: OItem <RefreshNode>
  //
  // Nodes marked <RefreshChildren> must have their contents refreshable when
  // Refresh message is received by the frontend. Arguments are paths.
  class MYSQLWBBACKEND_PUBLIC_FUNC LivePhysicalOverviewBE : public wb::PhysicalOverviewBE
  {
    virtual OverviewBE::ContainerNode * create_root_node(workbench_physical_ModelRef model, PhysicalOverviewBE *owner);

    workbench_physical_ModelRef _model;

  public:
    bec::GMutexLock lock_model() { return bec::GMutexLock(_model_mutex); }
  protected:
    GMutex *_model_mutex;

  public: // backend internal
    virtual std::string identifier() const;
    virtual std::string get_title();
    
    virtual std::string get_form_context_name() const;

  public:
    LivePhysicalOverviewBE(wb::WBContext *wb);
    ~LivePhysicalOverviewBE();

    virtual Node *do_get_node(const bec::NodeId &node) const;

    virtual bec::ToolbarItemList get_toolbar_items(const bec::NodeId &node);
    virtual bool activate_toolbar_item(const bec::NodeId &node, const std::string &name);

    virtual bec::MenuItemList get_popup_items_for_nodes(const std::vector<bec::NodeId> &nodes);
    virtual bool activate_popup_item_for_nodes(const std::string &name, const std::vector<bec::NodeId> &nodes);

    virtual bool is_expansion_disabled() { return true; }
    virtual int get_default_tab_page_index();

  public:
    void refresh_schemata_node();
    void load_schema_contents(db_SchemaRef schema);
    void refresh_schema_node(db_SchemaRef schema);

    virtual bool can_undo() { return false; }
    virtual bool can_redo() { return false; }
  public:
    typedef sigc::signal<void> RefreshSlot;
    typedef sigc::slot<void, LiveSchemaTree::SchemaNode> SchemaContentArrivedSlot;
    typedef sigc::slot<std::list<std::string> > SchemaListFetchSlot;
    typedef sigc::slot<bool, bec::NodeId, std::string, LiveSchemaTree::SchemaContentArrivedSlot> SchemaFetchSlot;
    typedef sigc::signal<void, std::string, LiveSchemaTree::ObjectType, std::string, std::string> ActivateObjectSignal;
    typedef sigc::signal<void, LiveSchemaTree::ObjectType, std::string, std::string> LiveObjectSignal;

    typedef sigc::slot<bec::MenuItemList, std::string, std::string, std::string> ObjectPluginMenuItemsSlot;
    typedef sigc::slot<bool, std::string, std::string, std::string, std::string> CallObjectPluginMenuItemsSlot;
  public:
    RefreshSlot refresh_signal;
    sigc::signal<void, const std::string&> active_schema_change_signal;
    //!SchemaListFetchSlot schema_list_fetch_slot;
    SchemaFetchSlot schema_fetch_slot;
    ActivateObjectSignal activate_object_signal;
    LiveObjectSignal alter_live_object_signal;
    //!LiveObjectSignal create_live_object_signal;
    LiveObjectSignal drop_live_object_signal;
    sigc::slot<int> active_schema_index;
    
    ObjectPluginMenuItemsSlot object_plugin_items_slot;
    CallObjectPluginMenuItemsSlot call_object_plugin_items_slot;
  };
};

#endif /* _WB_OVERVIEW_LIVE_PHYSICAL_H_ */
