/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "grtpp.h"
#ifndef _WIN32
#include <vector>
#endif

namespace bec {

class Clipboard {
  std::list<grt::ObjectRef> _contents;
  std::string _description;

  sigc::signal<void> _changed_signal;
public:
  Clipboard() {};
  virtual ~Clipboard() {};

  sigc::signal<void> signal_changed() { return _changed_signal; }
  void changed() { _changed_signal.emit(); }

  virtual void clear() { _contents.clear(); }

  virtual bool empty() { return _contents.empty(); }

  virtual void append_data(const grt::ObjectRef &data) { _contents.push_back(data); }
  virtual bool is_data() const { return _contents.empty(); }
  virtual std::list<grt::ObjectRef> get_data() { return _contents; }

  void set_content_description(const std::string description) { _description= description; }
  std::string get_content_description() { return _description; }

//  virtual void set_string(const std::string &str)= 0;
//  virtual std::string get_string()= 0;
};

};
