/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "stdafx.h"
#include "refresh_ui.h"

using namespace bec;

//------------------------------------------------------------------------------

void RefreshUI::set_refresh_ui_slot(const RefreshSlot &slot)
{
  _refresh_ui = slot;
}

//------------------------------------------------------------------------------

void bec::RefreshUI::set_partial_refresh_ui_slot(const bec::RefreshUI::PartialRefreshSlot &slot)
{
  _partial_refresh_ui = slot;
}

//------------------------------------------------------------------------------

void bec::RefreshUI::do_partial_ui_refresh(const int what)
{
  _partial_refresh_ui(what);
}

//------------------------------------------------------------------------------

void bec::RefreshUI::do_ui_refresh()
{
  _refresh_ui();
}

