/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __REFRESH_UI_H__
#define __REFRESH_UI_H__

#include "wbpublic_public_interface.h"
#include <sigc++/sigc++.h>

namespace bec
{

//! Class to save on typing and copy/paste of code. If you need to 
//! have a refresh feedback from BE to FE just derive from RefreshUI.
class WBPUBLICBACKEND_PUBLIC_FUNC RefreshUI
{
  public:
    virtual ~RefreshUI() {}
    
    typedef sigc::slot<void>              RefreshSlot;
    typedef sigc::slot<void,const int>    PartialRefreshSlot;

    void set_refresh_ui_slot(const RefreshSlot &slot);
    //! A way to make a refresh of part of the editor
    //! This actually is preffed upon whole-thing refresh
    void set_partial_refresh_ui_slot(const PartialRefreshSlot &slot);

    void do_partial_ui_refresh(const int what);
    void do_ui_refresh();

    void block_auto_refresh()    { _refresh_ui.block(); _partial_refresh_ui.block(); }
    void unblock_auto_refresh()  { _refresh_ui.unblock(); _partial_refresh_ui.unblock(); }

  private:
    sigc::slot<void>      _refresh_ui;
    PartialRefreshSlot    _partial_refresh_ui;
};

}

#ifdef _MSC_VER
#pragma make_public(::bec::RefreshUI)
#endif

#endif
