/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __VALIDATION_MANAGER_H__
#define __VALIDATION_MANAGER_H__

#include "wbpublic_public_interface.h"
#include "grtpp.h"
#include "grts/structs.app.h"

#include "wb_config.h"                                                                                                                 
#include "tree_model.h"
#include "refresh_ui.h"
#include <deque>


// Common tag names
#define CHECK_NAME "name"
#define CHECK_SYNTAX "syntax"
#define CHECK_EFFICIENCY "efficiency"
#define CHECK_LOGIC "logic"

namespace bec
{

class GRTManager;

class WBPUBLICBACKEND_PUBLIC_FUNC ValidationMessagesBE : public ListModel, public RefreshUI
{
  public:
    enum ValidationMessageColumns
    {
      Description = 1
    };

    ValidationMessagesBE();

    void clear();
    virtual bool get_field(const NodeId &node, int column, std::string &value);
    virtual IconId get_field_icon(const NodeId &node, int column, IconSize size);
    virtual void refresh() {}
    virtual int count();

    virtual int get_node_popup_items(const NodeId& node, MenuItemList& menu);
    virtual void activate_node_popup_item(const NodeId &node, const std::string &name);

  private:
    void validation_message(const grt::Validator::Tag& tag, const grt::ObjectRef&, const std::string&, const int level);

    IconId _error_icon;
    IconId _warning_icon;
    IconId _info_icon;

    struct Message
    {
      Message(){}
      Message(const std::string& message, const grt::ObjectRef& object, const grt::Validator::Tag& _tag)
          :msg(message)
          ,obj(object)
          ,tag(_tag)
      {}
      std::string          msg;
      grt::ObjectRef       obj;
      grt::Validator::Tag  tag;
    };

    typedef std::deque<Message>  MessageList;
    MessageList  _errors;
    MessageList  _warnings;

    static bool match_message(const Message& m, const grt::ObjectRef& obj, const grt::Validator::Tag& tag);
    void remove_messages(MessageList* ml, const grt::ObjectRef& obj, const grt::Validator::Tag& tag);
};

class WBPUBLICBACKEND_PUBLIC_FUNC ValidationManager
{
  public:
    // const int parameter in MessageSignal is a grt::MessageType
    typedef sigc::signal<void, const grt::Validator::Tag&, const grt::ObjectRef&, const std::string&, const int> MessageSignal;
    
    static void scan(GRTManager* grtm);
    static void register_validator(grt::GRT* grt, const std::string& type, grt::Validator* v);
    static bool validate_instance(const grt::ObjectRef& obj, const grt::Validator::Tag& tag);

    static MessageSignal& signal_notify();
    static void message(const grt::Validator::Tag&, const grt::ObjectRef&, const std::string&, const int level);//level is grt::MessageType
    static void clear();
  private:
    static bool is_validation_plugin(const app_PluginRef& plugin);

    static MessageSignal* _signal_notify;
};

//------------------------------------------------------------------------------
inline bec::ValidationManager::MessageSignal& bec::ValidationManager::signal_notify()
{
  if (!_signal_notify)
    _signal_notify = new ValidationManager::MessageSignal;

  return *_signal_notify;
}


}

#endif
