/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _EDITOR_VIEW_H_
#define _EDITOR_VIEW_H_

#include "grtdb/editor_dbobject.h"
#include "grt/tree_model.h"
#include "wbpublic_public_interface.h"

namespace bec {

  class WBPUBLICBACKEND_PUBLIC_FUNC ViewEditorBE : public DBObjectEditorBE
  {
  protected:
    db_ViewRef _view;
    bool _has_syntax_error;

  public:
    virtual db_DatabaseObjectRef get_dbobject() { return get_view(); }
    virtual db_ViewRef& get_view() { return _view; }

    virtual std::string get_query();
    virtual void set_query(const std::string &sql, bool sync);
    grt::ValueRef parse_sql(grt::GRT*, grt::StringRef sql);
    bool has_syntax_error() { return _has_syntax_error; }

    virtual Sql_editor::Ref get_sql_editor();

    ViewEditorBE(GRTManager *grtm, const db_ViewRef &view, const db_mgmt_RdbmsRef &rdbms);
  };

};

#ifdef _WIN32
#pragma make_public(::bec::ViewEditorBE)
#endif

#endif /* _EDITOR_VIEW_H_ */
