/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef _SQL_INSERTS_LOADER_H_
#define _SQL_INSERTS_LOADER_H_


#include "wbpublic_public_interface.h"
#include <sigc++/sigc++.h>
#include <boost/shared_ptr.hpp>
#include <vector>
#include <string>


/**
 * Defines interface to facilitate loading data from inserts SQL script.
 * 
 * @ingroup sqlparser
 */
class WBPUBLICBACKEND_PUBLIC_FUNC Sql_inserts_loader
{
public:
  typedef boost::shared_ptr<Sql_inserts_loader> Ref;
  
public:
  Sql_inserts_loader() {}
  virtual ~Sql_inserts_loader() {}

  virtual void load(const std::string &sql, const std::string &schema_name)= 0;

  typedef std::vector<std::string> Strings;
  typedef sigc::slot<void, const std::string&, const std::pair<std::string, std::string>&, const Strings&, const Strings&, const std::vector<bool>&> Process_insert; // sql, schema_name, table_name, fields_names, fields_values
  void process_insert_cb(Process_insert cb) { _process_insert= cb; }

protected:
  Process_insert _process_insert;
};


#endif // _SQL_INSERTS_LOADER_H_
