/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _CONFIRM_SAVE_DIALOG_H_
#define _CONFIRM_SAVE_DIALOG_H_

#include <mforms/mforms.h>
#include "wbpublic_public_interface.h"

class WBPUBLICBACKEND_PUBLIC_FUNC ConfirmSaveDialog : public mforms::Form
{
public:
  enum Result
  {
    ReviewChanges,
    Cancel,
    DiscardChanges
  };
private:
  mforms::Box _box;
  mforms::Label _caption;
  mforms::ScrollPanel _scroller;
  mforms::Box _checkboxes;
  mforms::Button _review_button;
  mforms::Button _cancel_button;
  std::string _last_group;
  int _item_count;
  Result _result;

  void discard_clicked();
public:
  ConfirmSaveDialog(mforms::Form *owner, 
                    const std::string &window_title,
                    const std::string &caption);

  void add_item(const std::string &group, const std::string &name);
  void add_item(const std::string &name);
  
  int change_count() { return _item_count; }
  Result run();
};

#endif
