#ifndef _CONNECTION_PAGE_H_
#define _CONNECTION_PAGE_H_


#include "grtui/grtdb_connect_panel.h"

class ConnectionPage : public grtui::WizardPage
{
public:
  ConnectionPage(grtui::WizardForm *form, const char *name= "connect")
    : WizardPage(form, name), _dbconn(0)
  {
    set_title(_("Set parameters for connecting to a DBMS"));
    set_short_title(_("Connection Options"));

    add(&_connect, true, true);
    
    _connect.signal_validation_state_changed().
      connect(sigc::mem_fun(this, &ConnectionPage::connection_validation_changed));
  }
 
  void set_db_connection(DbConnection *conn)
  {
    _dbconn= conn;
    _connect.init(_dbconn);
  }

protected:  
  virtual bool pre_load()
  {
    if (!_dbconn)
      throw std::logic_error("must call set_db_connection() 1st");
    
    return true;
  }

  virtual bool advance()
  { 
    return WizardPage::advance();
  }

  void connection_validation_changed(const std::string &error, bool ok)
  {
    if (!ok)    
      _form->set_problem(error);
    else
      _form->clear_problem();
  }

protected:
  DbConnection *_dbconn;
  grtui::DbConnectPanel _connect;
};

#endif // _CONNECTION_PAGE_H_