/* 
 *  2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _FILE_CHARSET_DIALOG_H_
#define _FILE_CHARSET_DIALOG_H_

#include <mforms/mforms.h>
#include "wbpublic_public_interface.h"

class WBPUBLICBACKEND_PUBLIC_FUNC FileCharsetDialog : public mforms::Form
{
  mforms::TextEntry _charset;
  mforms::Button _ok;
  mforms::Button _cancel;

  FileCharsetDialog(const std::string &title, const std::string &message,
                    const std::string &default_encoding);
  
public:
  std::string run();
  
  static bool ensure_filedata_utf8(const char *data, size_t length, 
                                   const std::string &filename,
                                   std::string &output_str);
};

#endif /* _FILE_CHARSET_DIALOG_H_ */
