/* 
 * (c) 2008-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "stdafx.h"
#include "grtdb_connect_dialog.h"
#include "string_utilities.h"

using namespace grtui;

DbConnectionDialog::DbConnectionDialog(const db_mgmt_ManagementRef &mgmt)
: mforms::Form(0), _panel(true), _top_vbox(false), _bottom_hbox(true)
{
  set_content(&_top_vbox);
  
  _panel.init(mgmt);
  
  _top_vbox.set_padding(MF_WINDOW_PADDING);
  
  _top_vbox.add(&_panel, true, true);
  _top_vbox.add(&_bottom_hbox, false, true);
  
  mforms::Utilities::add_end_ok_cancel_buttons(&_bottom_hbox, &_ok_button, &_cancel_button);

  _bottom_hbox.set_spacing(MF_BUTTON_SPACING);
  _ok_button.set_text(_("OK"));
  _cancel_button.set_text(_("Cancel"));
  
  set_title(_("Connect to Database"));
  
  _ok_button.signal_clicked().connect(sigc::mem_fun(this, &DbConnectionDialog::ok_clicked));
  _cancel_button.signal_clicked().connect(sigc::mem_fun(this, &DbConnectionDialog::cancel_clicked));
  
  set_size(700, 500);
  center();
}


db_mgmt_ConnectionRef DbConnectionDialog::run()
{
  if (run_modal(&_ok_button, &_cancel_button))
    return _panel.get_connection();

  return db_mgmt_ConnectionRef();
}

void DbConnectionDialog::ok_clicked()
{
}


void DbConnectionDialog::cancel_clicked()
{
}


void DbConnectionDialog::test_clicked()
{
}

