/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _GRTDB_OBJECT_FILTER_H_
#define _GRTDB_OBJECT_FILTER_H_

#include "mforms/mforms.h"
#include "grt/grt_manager.h"
#include "grtdb/db_object_filter.h"

namespace grtui
{
  
  class WBPUBLICBACKEND_PUBLIC_FUNC DBObjectFilterFrame : public mforms::Panel
  {
  public:
    DBObjectFilterFrame(bec::GRTManager *grtm);

    void set_object_class(const std::string &oclass, const std::string &caption_format);
    void set_models(bec::GrtStringListModel *model, bec::GrtStringListModel *excl_model);
    
    void set_active(bool flag);
    bool get_active();

  protected:
    bec::DBObjectFilterBE _filter_be;

    bec::GrtStringListModel *_model;
    bec::GrtStringListModel *_exclude_model;
    
    mforms::Box _box;

    mforms::Table _summary_table;

    mforms::ImageBox _icon;

    mforms::CheckBox _check;
    
    mforms::Label _summary_label;

    mforms::Button _show_button;
    

    mforms::Table _detailed_table;

    mforms::Label _filter_help_label;
    mforms::Label _search_label;
    mforms::Label _filter_label;
    mforms::TextEntry _search_text;
    mforms::Selector _filter_combo;
    mforms::Button _add_button;
    mforms::Button _remove_button;

    mforms::ListBox _object_list;
    mforms::ListBox _mask_list;
    
    mforms::Button _add1_button;
    mforms::Button _add2_button;
    mforms::Button _del1_button;
    mforms::Button _del2_button;
    mforms::Button _mask_button;
    
    void toggle_enabled();
    void toggle_detailed();

    void update_button_enabled();
    
    void refresh();

    void add_mask();
    void add_clicked(bool all);
    void del_clicked(bool all);
  };
};

#endif /* _GRTDB_OBJECT_FILTER_H_ */
