/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _WIZARD_VIEW_TEXT_PAGE_H_
#define _WIZARD_VIEW_TEXT_PAGE_H_



namespace grtui {

class WBPUBLICBACKEND_PUBLIC_FUNC ViewTextPage : public WizardPage
{
public:
  enum Buttons
  {
    SaveButton = (1<<0),
    CopyButton = (1<<1)
  };
  
  ViewTextPage(WizardForm *form, const char *name= "preview", Buttons buttons= (Buttons)0, const std::string &filetype="");

  void set_text(const std::string &text);
  std::string get_text();
  
  void set_editable(bool flag= true);

  void save_text_to(const std::string &path);
  
protected:
  mforms::TextBox _text;
  
  mforms::Box _button_box;
  mforms::Button _save_button;
  mforms::Button _copy_button;
  
  std::string _filetype;
  
  void save_clicked();
  void copy_clicked();
};

};

#endif /* _WIZARD_VIEW_TEXT_PAGE_H_ */

