/* 
 * (c) 2007-2008 MySQL AB, 2008-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "stdafx.h"

#include <grts/structs.db.h>

#include "string_utilities.h"
#include <grtpp_undo_manager.h>

#include "grt/common.h"

//================================================================================
// db_DatabaseObject


void db_DatabaseObject::init()
{
}

db_DatabaseObject::~db_DatabaseObject()
{
}

void db_DatabaseObject::lastChangeDate(const grt::StringRef &value)
{
  grt::ValueRef ovalue(_lastChangeDate);

  _lastChangeDate= value;
  
  member_changed("lastChangeDate", ovalue, value);

  if (_owner.is_valid() && _owner.is_instance(db_Schema::static_class_name()))
  {
    db_SchemaRef schema(db_SchemaRef::cast_from(_owner));
    schema->signal_refreshDisplay().emit(this);
  }
}


void db_DatabaseObject::name(const grt::StringRef &value)
{
  grt::StringRef oname(_name);

  grt::AutoUndo undo(get_grt(), !is_global());

  _name= value;
  _lastChangeDate= bec::fmttime(0, DATETIME_FMT);

  member_changed("name", oname, value);

  undo.end(base::strfmt(_("Rename '%s' to '%s'"), oname.c_str(), value.c_str()));

  if (_owner.is_valid() && _owner.is_instance(db_Schema::static_class_name()))
  {
    db_SchemaRef schema(db_SchemaRef::cast_from(_owner));
    schema->signal_refreshDisplay().emit(this);
  }
}





