/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef _SQL_SCRIPT_RUN_WIZARD_H_
#define _SQL_SCRIPT_RUN_WIZARD_H_


#include "wbpublic_public_interface.h"
#include "grtui/grt_wizard_plugin.h"
#include "grtui/wizard_progress_page.h"
#include "grtui/wizard_finished_page.h"


class WBPUBLICBACKEND_PUBLIC_FUNC SqlScriptReviewPage : public grtui::WizardPage
{
public:
  SqlScriptReviewPage(grtui::WizardForm *form);
protected:
  virtual void enter(bool advancing);
  virtual bool advance();
  virtual std::string next_button_caption();
private:
  mforms::Box _box;
  mforms::Label _page_heading;
  mforms::Label _sql_script_heading;
  mforms::TextBox _sql_script;
};


class WBPUBLICBACKEND_PUBLIC_FUNC SqlScriptApplyPage : public grtui::WizardProgressPage
{
private:
  std::string _log;
  int _err_count;
public:
  SqlScriptApplyPage(grtui::WizardForm *form);
  int on_error(long long err_code, const std::string& err_msg, const std::string& err_sql);
  int on_exec_progress(float progress);
  int on_exec_stat(long success_count, long err_count);
  sigc::slot<void, std::string &> apply_sql_script;
  bool execute_sql_script();
  virtual std::string next_button_caption();
  virtual bool allow_back();
  virtual bool allow_next();
  virtual bool allow_cancel();
  virtual void enter(bool advancing);
}; 


class WBPUBLICBACKEND_PUBLIC_FUNC SqlScriptRunWizard : public grtui::WizardForm
{
public:
  SqlScriptReviewPage *review_page;
  SqlScriptApplyPage *apply_page;
public:
  SqlScriptRunWizard(bec::GRTManager *grtm);
  bool has_errors();
  bool applied();
};


#endif /* _SQL_SCRIPT_RUN_WIZARD_H_ */
