/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _WORKBENCH_MODEL_NOTEFIGURE_IMPL_H_
#define _WORKBENCH_MODEL_NOTEFIGURE_IMPL_H_

#include "model_figure_impl.h"
#include "grts/structs.workbench.model.h"

#include "note_figure.h"

class WBPUBLICBACKEND_PUBLIC_FUNC workbench_model_NoteFigure::ImplData : public model_Figure::ImplData
{
   typedef model_Figure::ImplData super;
   
 protected:
   wbfig::Note *_figure;
   
   virtual bool realize();

 public:
   ImplData(workbench_model_NoteFigure *self);
   
   void set_text(const std::string &text);
   
   virtual mdc::CanvasItem* get_canvas_item() const { return _figure; }

   virtual void unrealize();
   
 private:
   workbench_model_NoteFigure *self() const { return (workbench_model_NoteFigure*)_self; }
}; 

#endif
