/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __DB_SQL_EDITOR_WR_H__
#define __DB_SQL_EDITOR_WR_H__

#include "sqlide/wb_sql_editor_form.h"

#include "db_sql_editor_history_wr.h"
#include "Overview.h"

namespace MySQL {
namespace GUI {
namespace Workbench {


using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;
using namespace MySQL::Grt;
using namespace MySQL::Grt::Db;
using namespace MySQL::Grt::Db::Sql;


public ref class Db_sql_editor : public UIForm
{
public:
  typedef ManagedRef<::Db_sql_editor> ^ Ref;
  Db_sql_editor(IntPtr ptr);
  Ref ref() { return _ref; }
private:
  Ref _ref;
private:
  ~Db_sql_editor();

public:
  MySQL::Grt::ActionList ^action_list;

public:
  GrtManager ^ grt_manager() { return gcnew GrtManager(_ref->grt_manager()); }
  Sql::Sql_editor ^ sql_editor() { return Ref2Ptr_<::Sql_editor, Sql::Sql_editor>(_ref->sql_editor()); }
  Sql::Sql_editor ^ sql_editor(int index) { return Ref2Ptr_<::Sql_editor, Sql::Sql_editor>(_ref->sql_editor(index)); }
  int sql_editor_count() { return _ref->sql_editor_count(); }
  String ^ sql_editor_caption(int index) { return CppStringToNative(_ref->sql_editor_caption(index)); }
  int add_sql_editor() { return _ref->add_sql_editor(); }
  void remove_sql_editor(int index) { return _ref->remove_sql_editor(index); }
  int active_sql_editor_index() { return _ref->active_sql_editor_index(); }
  void active_sql_editor_index(int val) { _ref->active_sql_editor_index(val); }
  bool sql_editor_will_close(int index) { return _ref->sql_editor_will_close(index); }

  void active_recordset(Recordset ^val);

  String ^ caption() { return CppStringToNative(_ref->caption()); }

  String ^ connection_info() { return CppStringToNative(_ref->connection_info()); }

  void connect() { _ref->connect(); }
  bool connected() { return _ref->connected(); }
  void cancel_query() { _ref->cancel_query(); }

  void reset() { _ref->reset(); }
  void exec_sql(String ^sql, bool wrap_with_non_std_delimiter) { _ref->exec_sql(NativeToCppString(sql), false, wrap_with_non_std_delimiter); }
  void commit() { _ref->commit(); }
  void rollback() { _ref->rollback(); }
  int recordset_count() { return _ref->recordset_count(); }
  Recordset ^ recordset(int index);

public:
  VarGridModel ^ log() { return _log; }
  DbSqlEditorHistory ^ history() { return _history; }
  String ^ restore_sql_from_history(int entry_index, List<int> ^detail_indexes);
private:
  VarGridModel ^_log;
  DbSqlEditorHistory ^_history;

public:
  void get_log_event_details(int log_event_no, [Out] int %log_event_type_code, [Out] String^ %log_event_time, [Out] String^ %log_event_action, [Out] String^ %log_event_message);

public:
  bool recordsets_are_pinned_by_default() { return _ref->recordsets_are_pinned_by_default(); }
  void recordsets_are_pinned_by_default(bool value) { _ref->recordsets_are_pinned_by_default(value); }

public:
  bool can_close() { return _ref->can_close(); }

public:
  List<String^>^ schemata();
  void active_schema(String ^schema) { _ref->active_schema(NativeToCppString(schema)); }
  String ^ active_schema() { return CppStringToNative(_ref->active_schema()); }
  int active_schema_index() { return _ref->active_schema_index(); }

public:
  ::MySQL::Workbench::Overview ^live_physical_overview();
  bool is_physical_overview_enabled() { return _ref->is_physical_overview_enabled(); }
private:
  ::MySQL::Workbench::Overview ^_live_physical_overview;

public:
  GrtThreadedTask ^exec_sql_task;

private:
  RefreshUI ^_refresh_ui;
public:
  RefreshUI ^refresh_ui() { return _refresh_ui; }

  enum class PartialRefreshType
  {
    RefreshSidebar= ::Db_sql_editor::RefreshSidebar, // update the sidebar
    RefreshActiveSchemaSelector= ::Db_sql_editor::RefreshActiveSchemaSelector,
    RefreshSchemaTree= ::Db_sql_editor::RefreshSchemaTree, // refresh live schema tree
    RefreshEditor= ::Db_sql_editor::RefreshEditor, // refresh the text editor using data from backend
    RefreshSnippets= ::Db_sql_editor::RefreshSnippets,
    RefreshSnippetCollections= ::Db_sql_editor::RefreshSnippetCollections,
    RefreshEditorTitle= ::Db_sql_editor::RefreshEditorTitle,
    RefreshRecordsetTitle= ::Db_sql_editor::RefreshRecordsetTitle,
    RunCurrentScript= ::Db_sql_editor::RunCurrentScript
  };

public:
  TreeModel ^ schema_tree() { return gcnew TreeModel(_ref->get_schema_tree()); }

public:
  typedef DelegateSlot1<int, int,
    long long, long long> Close_recordset_ui_cb;
  void close_recordset_ui_cb(Close_recordset_ui_cb::ManagedDelegate ^cb);
private:
  Close_recordset_ui_cb ^_close_recordset_ui_cb;

public:
  typedef DelegateSlot2<void, void, std::string, String^, bool, bool> Output_text_ui_cb;
  void output_text_ui_cb(Output_text_ui_cb::ManagedDelegate ^cb);
private:
  Output_text_ui_cb ^_output_text_ui_cb;

public:
  typedef DelegateSlot1<int, int,
    int, int> Sql_editor_new_ui_cb;
  void sql_editor_new_ui_cb(Sql_editor_new_ui_cb::ManagedDelegate ^cb);
private:
  Sql_editor_new_ui_cb ^_sql_editor_new_ui_cb;

public:
  typedef DelegateSlot1<int, int,
    std::string, String^> Sql_editor_text_insert_cb;
  void sql_editor_text_insert_cb(Sql_editor_text_insert_cb::ManagedDelegate ^cb);
private:
  Sql_editor_text_insert_cb ^_sql_editor_text_insert_cb;
};


};  // namespace Workbench
};  // namespace GUI
};  // namespace MySQL


#endif // __DB_SQL_EDITOR_WR_H__
