/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include "stdafx.h"


namespace MySQL {
namespace Grt {
namespace Db {


using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;
using namespace MySQL::Grt;


Recordset::Recordset(Ref ref)
:
VarGridModel(Ref_N2M<::VarGridModel>(&ref)),
_ref(ref),
task(gcnew GrtThreadedTask(_ref->task.get())),
action_list(gcnew ActionList(&_ref->action_list()))
{
_refresh_ui_status_bar_conn= new sigc::connection();
}


Recordset::Recordset(IntPtr nref_ptr)
:
_ref(gcnew ManagedRef<::Recordset>(nref_ptr)),
VarGridModel(Ref_N2M<::VarGridModel>(&_ref)),
task(gcnew GrtThreadedTask(_ref->task.get())),
action_list(gcnew ActionList(&_ref->action_list()))
{
  _refresh_ui_status_bar_conn= new sigc::connection();
}


Recordset::~Recordset()
{
  if (!(void*)~_ref)
    return;
  delete _refresh_ui_status_bar_conn;
  delete _refresh_ui_status_bar_cb;
  delete action_list;
  delete task;
  delete _ref;
}


void Recordset::refresh_ui_status_bar_cb(Refresh_ui_cb::ManagedDelegate ^cb)
{
  _refresh_ui_status_bar_conn->disconnect();
  
  if (cb)
  {
    _refresh_ui_status_bar_cb= gcnew Refresh_ui_cb(cb);
    *_refresh_ui_status_bar_conn = _ref->refresh_ui_status_bar_signal.connect(sigc::hide_return(_refresh_ui_status_bar_cb->get_slot()));
  }
  else
    _refresh_ui_status_bar_cb= nullptr;
}


void Recordset::pending_changes(int %upd_count, int %ins_count, int %del_count)
{
  int upd_count_, ins_count_, del_count_;
  _ref->pending_changes(upd_count_, ins_count_, del_count_);
  upd_count=upd_count_; ins_count=ins_count_; del_count=del_count_;
}


void Recordset::copy_rows_to_clipboard(List<int> ^indeces)
{
  std::vector<int> indeces_= IntListToCppVector(indeces);
  _ref->copy_rows_to_clipboard(indeces_);
}


void Recordset::data_storages_for_export(List<String ^> ^%formats_names, List<String ^> ^%formats_desc)
{
  std::vector<std::string> formats_names_;
  std::vector<std::string> formats_desc_;
  _ref->data_storages_for_export(formats_names_, formats_desc_);
  formats_names= CppStringListToNative(formats_names_);
  formats_desc= CppStringListToNative(formats_desc_);
}


Recordset_data_storage ^ Recordset::data_storage_for_export(String ^format)
{
  return Ref2Ptr<::Recordset_data_storage, Recordset_data_storage>
    (_ref->data_storage_for_export(NativeToCppString(format)));
}


List<MySQL::Grt::ToolbarItem^> ^Recordset::get_toolbar_items()
{
  bec::ToolbarItemList items= _ref->get_toolbar_items();
  return CppVectorToObjectList<::bec::ToolbarItem, MySQL::Grt::ToolbarItem>(items);
}


List<MySQL::Grt::MenuItem^> ^Recordset::get_popup_menu_items(List<int> ^rows, int column)
{
  std::vector<int> rows_= NativeListToCppVector<int, int>(rows);
  bec::MenuItemList items= _ref->get_popup_menu_items(rows_, column);
  return CppVectorToObjectList<::bec::MenuItem, MySQL::Grt::MenuItem>(items);
}


bool Recordset::activate_popup_menu_item(String ^action, List<int> ^rows, int column)
{
  std::vector<int> rows_= NativeListToCppVector<int, int>(rows);
  return _ref->activate_popup_menu_item(NativeToCppString(action), rows_, column);
}


bool Recordset::delete_nodes(List<NodeId^> ^nodes)
{
  std::vector<bec::NodeId> nodes_= convert_node_list(nodes);
  return _ref->delete_nodes(nodes_);
}


};  // namespace Db
};  // namespace Grt
};  // namespace MySQL
