/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __RECORDSET_TEXT_STORAGE_WR_H__
#define __RECORDSET_TEXT_STORAGE_WR_H__


#include "sqlide/recordset_text_storage.h"


namespace MySQL {
namespace Grt {
namespace Db {


public ref class Recordset_text_storage : public Recordset_data_storage
{
public:
  Recordset_text_storage(Recordset_data_storage ^ds)
    : Recordset_data_storage(ds->ref()),
    _inner(dynamic_cast<::Recordset_text_storage::Ref::pointer>((&ds->ref()).get()))
  {}
private:
  ::Recordset_text_storage::Ref::pointer _inner;

public:
  void parameter_value(String ^name, String ^value) { _inner->parameter_value(NativeToCppString(name), NativeToCppString(value)); }

public:
  void data_format(String ^format) { _inner->data_format(NativeToCppString(format)); }
  void file_path(String ^file_path) { _inner->file_path(NativeToCppString(file_path)); }
};


};  // namespace Db
};  // namespace Grt
};  // namespace MySQL


#endif // __RECORDSET_TEXT_STORAGE_WR_H__
