#ifndef __ROUTINE_EDITOR_H__
#define __ROUTINE_EDITOR_H__

#include "DBObjectEditorBE.h"
#include "GrtTemplates.h"
#include "grtdb/editor_routine.h"

#pragma make_public(::bec::RoutineEditorBE)

namespace MySQL {
namespace Grt {
namespace Db {

public ref class RoutineEditorBE : public DBObjectEditorBE
{
protected:
  RoutineEditorBE(::bec::RoutineEditorBE *inn)
    : DBObjectEditorBE(inn)
  {}

public:
  ::bec::RoutineEditorBE *get_unmanaged_object()
  { return static_cast<::bec::RoutineEditorBE *>(inner); }
  
  String^ get_sql()
  { return CppStringToNative(get_unmanaged_object()->get_sql()); }

  void set_sql(String ^query, bool sync)
  { get_unmanaged_object()->set_sql(NativeToCppString(query), sync); }

  String^ get_name()
  { return CppStringToNative(get_unmanaged_object()->get_name()); }

  void set_name(String ^query)
  { get_unmanaged_object()->set_name(NativeToCppString(query)); }

  String^ get_comment()
  { return CppStringToNative(get_unmanaged_object()->get_comment()); }

  void set_comment(String ^query)
  { get_unmanaged_object()->set_comment(NativeToCppString(query)); }

  String^ get_formatted_sql_for_editing([Out] int %cursor_pos)
  { 
    int cpos= cursor_pos; 
    String ^res= CppStringToNative(get_unmanaged_object()->get_formatted_sql_for_editing(cpos)); 
    cursor_pos= cpos;
    return res;
  }

  bool has_syntax_error() { return get_unmanaged_object()->has_syntax_error(); }
};

} // namespace Db
} // namespace Grt
} // namespace MySQL

#endif // __ROUTINE_EDITOR_H__