/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef __GRT_SHELL_WINDOW_H__
#define __GRT_SHELL_WINDOW_H__

#include <mforms/mforms.h>
#include "grt/grt_manager.h"
#include "wb_context.h"
#include "mforms/grttreeview.h"

class GRTCodeEditor;

class GRTShellWindow : public mforms::Form
{
public:
  GRTShellWindow(wb::WBContext* context);
  
  bec::GRTManager *grtm() { return _context->get_grt_manager(); }
  
  virtual void show(bool flag=true);
  
  bool execute_script(const std::string &script, const std::string &language);
  
  GRTCodeEditor *add_editor(bool is_script, const std::string &language);
  void add_new_script();
  void open_script_file();
  
  void open_file_in_editor(const std::string &path, bool is_script);
  
  void close_editor(GRTCodeEditor *editor);
  void refresh_files();

  void set_editor_title(GRTCodeEditor *editor, const std::string &title);

  bool request_quit();
protected:
  wb::WBContext* _context;
  
  mforms::Splitter _hsplitter;
  mforms::Panel _header_panel;
  mforms::TabView _side_tab;
  mforms::TabView _main_tab;
  
  mforms::Button _file_add;
  mforms::Button _file_delete;
  mforms::TreeView _files_tree;

  mforms::Box _global_box1;
  mforms::Box _global_box2;
  mforms::Splitter _global_splitter;
  mforms::Selector _global_combo;
  mforms::GRTTreeView _global_tree;
  mforms::TextEntry _global_entry;
  mforms::GRTTreeView _global_list;
  bec::ValueInspectorBE *_inspector;
  bec::ValueTreeBE *_global_tree_be;

  mforms::Box _classes_box;
  mforms::Splitter _classes_splitter;
  mforms::Selector _classes_sorting;
  mforms::GRTTreeView _classes_tree;
  mforms::TextBox _classes_text;

  mforms::Splitter _modules_splitter;
  mforms::GRTTreeView _modules_tree;
  mforms::TextBox _modules_text;
  
  mforms::Box _shell_box;
  mforms::TextBox _shell_text;
  mforms::Box _shell_hbox;
  mforms::Label _shell_prompt;
  mforms::TextEntry _shell_entry;
  
  mforms::Splitter _snippet_box;
  mforms::Box _snippet_vbox;
  mforms::Box _snippet_bbox;
  mforms::TreeView _snippet_list;
#ifdef _WIN32
  mforms::CodeEditor _snippet_text;
#else
  mforms::TextBox _snippet_text;
#endif
  mforms::Button _snippet_add;
  mforms::Button _snippet_del;
  mforms::Button _snippet_copy;
  mforms::Menu _snippet_menu;
  int _global_snippet_count;
  std::string _comment_prefix;
  std::string _script_extension;
  
  std::vector<GRTCodeEditor*> _editors;
  
  bool _first_show;

  void refresh_all();
  void side_tab_changed();

  void shell_action(mforms::TextEntryAction action);

  void handle_prompt(const std::string &text);
  void handle_output(const std::string &text);
  void handle_error(const std::string &text, const std::string &detail);
  void set_globals_tree_path(const std::string &path);
  
  void global_selected();
  void class_selected();
  void module_selected();
  void change_class_sorting();
  void change_global_path();
  
  void delete_selected_file();

  void file_list_activated(int row, int column);
  void add_files_from_dir(const std::string &dir, bool is_script);
  GRTCodeEditor* get_editor_for(const std::string& path, bool select_tab);
  
  void load_snippets_from(const std::string &path);
  void save_snippets();
  void refresh_snippets();
  void add_snippet();
  void del_snippet();
  void copy_snippet();
  void run_snippet();
  void scriptize_snippet();
  void snippet_selected();
  void snippet_changed();
  
  void snippet_menu_activate(const std::string &action);

  void shell_closed();

  void load_state();
  void save_state();

  bool on_tab_closing(int index);
  void on_tab_closed(int index);
};

#endif
