/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _NEWCONNECTIONWIZARD_H_
#define _NEWCONNECTIONWIZARD_H_


#include "workbench/wb_backend_public_interface.h"
#include <mforms/mforms.h>

#include "grtui/db_conn_be.h"
#include "grtui/grtdb_connect_panel.h"
#include "grt/grt_manager.h"

class MYSQLWBBACKEND_PUBLIC_FUNC NewConnectionWizard : public mforms::Form
{
public:
  NewConnectionWizard(const db_mgmt_ManagementRef &mgmt);
  ~NewConnectionWizard();
  
  db_mgmt_ConnectionRef run();
  
protected:
  db_mgmt_ManagementRef _mgmt;
  grtui::DbConnectPanel _panel;
  db_mgmt_ConnectionRef _connection;
  mforms::Box _top_vbox;
  
  mforms::TextEntry *_conn_name;
  
  mforms::Box _bottom_hbox;
  mforms::Button _ok_button;
  mforms::Button _cancel_button;
  mforms::Button _test_button;
};

#endif /* _NEWCONNECTIONWIZARD_H_ */
