#ifndef __GRID_VIEW_MODEL_H__
#define __GRID_VIEW_MODEL_H__


#include "linux_utilities/listmodel_wrapper.h"
#include "grt/tree_model.h"


class GridView;


class GridViewModel : public ListModelWrapper
{
public:
  typedef Glib::RefPtr<GridViewModel> Ref;
  static Ref create(bec::GridModel::Ref model, GridView *view, const std::string &name);
  ~GridViewModel();
protected:
  GridViewModel(bec::GridModel::Ref model, GridView *view, const std::string &name);

private:
  bec::GridModel::Ref _model;
  GridView *_view;

public:
  virtual bool handle_popup_event(GdkEvent* event);

public:
  int refresh(bool reset_columns);

public:
  int column_index(Gtk::TreeViewColumn* col);
private:
  std::map<Gtk::TreeViewColumn*, int> _col_index_map;

public:
  void row_numbers_visible(bool value) { _row_numbers_visible= value; }
private:
  bool _row_numbers_visible;

private:
  template <typename ValueTypeTraits>
  Gtk::TreeViewColumn * add_column(int index, const std::string &name, Editable editable, Gtk::TreeModelColumnBase *color_column);

  void get_cell_value(const iterator& iter, int column, GType type, Glib::ValueBase& value);
  void set_cell_value(const iterator& itier, int column, GType type, const Glib::ValueBase& value);
};


#endif // __GRID_VIEW_MODEL_H__
