/* 
 * (c) 2009-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#import "sigobjc++.h"
#import <Cocoa/Cocoa.h>

class Recordset;

@interface MGridView : NSTableView
{
  int mSelectedColumnIndex;
  int mSelectedRowIndex;
  int mOSelectedColumnIndex;
  int mOSelectedRowIndex;

  id selectionChangedActionTarget;
  SEL selectionChangedAction;
  
  Recordset *mRecordset;
}

- (void)setRecordset:(Recordset*)rset;

- (int)selectedColumnIndex;
- (int)selectedRowIndex;

- (void)selectCellAtRow:(int)row column:(int)column;

- (void)setSelectionChangedAction:(SEL)aSelector;
- (void)selectionChangedActionTarget:(id)target;
@end


