//
//  NSString_extras.mm
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 4/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import "NSString_extras.h"


@implementation NSString(CPPExtras)

+ (NSString*)stringWithCPPString:(const std::string&) str
{
  NSString* result = [NSString stringWithUTF8String: str.c_str()];
  
  // If the input string is not encoded in UTF-8 it might contain byte sequences
  // which can make up a wrong code if interpreted as UTF-8 and the above conversion fails.
  // In this case try again and initialize as normal ANSI (Latin 1) encoding.
  // This is quite a guessing game, but the price for using code pages in files.
  if (result == nil)
    result= [NSString stringWithCString: str.c_str() encoding: NSISOLatin1StringEncoding];

  return result;
}

@end
