using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace MySQL.GUI.Workbench
{
  public partial class ExceptionDialog : Form
  {
    private String errorInfo;

    public ExceptionDialog()
    {
      InitializeComponent();
    }

    public ExceptionDialog(String message, String info)
      : this()
    {
      messageLabel.Text = message;
      errorInfo = info;
    }

    private void reportBugButton_Click(object sender, EventArgs e)
    {
      System.Diagnostics.Process.Start("http://bugs.mysql.com/report.php");
    }

    private void copyInfoButton_Click(object sender, EventArgs e)
    {
      Clipboard.SetText(errorInfo);
    }

    private void copyStackTraceToClipboardToolStripMenuItem_Click(object sender, EventArgs e)
    {
      Clipboard.SetText(errorInfo);
    }


  }
}
