@echo off
echo ================================================================================
echo MySQL Interface Generation Script
echo ================================================================================
echo This script will build the genwrap tool and generate all header files
echo ================================================================================
echo .

echo Starting GRT interface generation.
echo .

rem Set search path to our debug folder to be able to find all required dlls for the wrapper.
rem Note: This requires that WB was successfully build at least once, otherwise the folder does not
rem       yet have all the dlls.
set PATH=../bin/debug;%PATH%

echo --------------------------------------------------------------------------------
echo Building genwrap tool...

echo Build Dependencies...

echo Build stage 1...
pushd ..\tools\genwrap
devenv genwrap.vcproj /build "Generator_Stage1|Win32"
popd
if errorlevel 1 goto error

..\tools\genwrap\Generator_Stage1\genwrap1.exe structs ../res/grt/structs.xml 			. grts
..\tools\genwrap\Generator_Stage1\genwrap1.exe structs ../res/grt/structs.app.xml 		. grts
..\tools\genwrap\Generator_Stage1\genwrap1.exe structs ../res/grt/structs.db.xml 			. grts
..\tools\genwrap\Generator_Stage1\genwrap1.exe structs ../res/grt/structs.db.maxdb.xml 		. grts
..\tools\genwrap\Generator_Stage1\genwrap1.exe structs ../res/grt/structs.db.mgmt.xml		. grts
..\tools\genwrap\Generator_Stage1\genwrap1.exe structs ../res/grt/structs.db.migration.xml	. grts
..\tools\genwrap\Generator_Stage1\genwrap1.exe structs ../res/grt/structs.db.mssql.xml		. grts
..\tools\genwrap\Generator_Stage1\genwrap1.exe structs ../res/grt/structs.db.mysql.xml		. grts
..\tools\genwrap\Generator_Stage1\genwrap1.exe structs ../res/grt/structs.db.oracle.xml		. grts
..\tools\genwrap\Generator_Stage1\genwrap1.exe structs ../res/grt/structs.db.query.xml		. grts
..\tools\genwrap\Generator_Stage1\genwrap1.exe structs ../res/grt/structs.db.sybase.xml		. grts
..\tools\genwrap\Generator_Stage1\genwrap1.exe structs ../res/grt/structs.eer.xml			. grts
..\tools\genwrap\Generator_Stage1\genwrap1.exe structs ../res/grt/structs.model.xml		. grts
..\tools\genwrap\Generator_Stage1\genwrap1.exe structs ../res/grt/structs.workbench.xml		. grts
..\tools\genwrap\Generator_Stage1\genwrap1.exe structs ../res/grt/structs.workbench.logical.xml	. grts
..\tools\genwrap\Generator_Stage1\genwrap1.exe structs ../res/grt/structs.workbench.model.xml	. grts
..\tools\genwrap\Generator_Stage1\genwrap1.exe structs ../res/grt/structs.workbench.physical.xml	. grts
..\tools\genwrap\Generator_Stage1\genwrap1.exe structs ../res/grt/structs.workbench.model.reporting.xml	. grts

echo Build stage 2...
pushd ..\tools\genwrap
devenv genwrap.vcproj /build "Generator_Stage2|Win32"
popd
if errorlevel 1 goto error

echo Build of genwrap tool completed.
echo .


echo --------------------------------------------------------------------------------
echo Generating files...


..\tools\genwrap\Generator_Stage2\genwrap2.exe interfaces ../modules/interfaces/diffsqlgen.h grti/diffsqlgen.h
..\tools\genwrap\Generator_Stage2\genwrap2.exe interfaces ../modules/interfaces/plugin.h grti/plugin.h
..\tools\genwrap\Generator_Stage2\genwrap2.exe interfaces ../modules/interfaces/wb_model.h grti/wb_model.h
..\tools\genwrap\Generator_Stage2\genwrap2.exe interfaces ../modules/interfaces/wb_model_reporting.h grti/wb_model_reporting.h
..\tools\genwrap\Generator_Stage2\genwrap2.exe interfaces ../modules/interfaces/wbvalidation.h grti/wbvalidation.h

goto finish

:error
echo --------------------------------------------------------------------------------
echo ##### The script aborted due to an error #####
pause
goto end

:finish
echo --------------------------------------------------------------------------------
echo Successfully finished the script.

:end
echo ================================================================================
