/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _SHARED_UTIL_FUNCTIONS_H_
#define _SHARED_UTIL_FUNCTIONS_H_

#include "common.h"

#include <stdlib.h>
#include <stdio.h>
#include <glib.h>

#ifdef __APPLE__
  #include "sys/stat.h"
#endif

#ifdef __cplusplus
extern "C" {   
#endif /* __cplusplus */

BASELIBRARY_PUBLIC_FUNC FILE* base_fopen(const char *filename, const char *mode);
BASELIBRARY_PUBLIC_FUNC int base_remove(const char *filename);
BASELIBRARY_PUBLIC_FUNC int base_rename(const char *oldname, const char *newname);
#ifdef _WIN32
  BASELIBRARY_PUBLIC_FUNC int base_stat(const char *filename, struct _stat *stbuf);
#else
  BASELIBRARY_PUBLIC_FUNC int base_stat(const char *filename, struct stat *stbuf);
#endif

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif

