/* 
 * Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GEOMETRY_H_
#define _GEOMETRY_H_

/**
 * Definitions and implementations of geometry related types and classes. Defines all the usual base types
 * like point, rectangle and the like.
 */

#include "common.h"

namespace MySQL {
namespace Geometry {

  typedef struct BASELIBRARY_PUBLIC_FUNC Rect
  {
    double left;
    double top;
    double width;
    double height;

    bool contains(double x, double y);
    bool contains_flipped(double x, double y);
    void inflate(double horizontal, double vertical);

    double right();
    double bottom();
    bool empty();

    Rect();
    Rect(double x, double y, double w, double h);

  } Rect;

  typedef struct BASELIBRARY_PUBLIC_FUNC Point
  {
    double x;
    double y;

    Point();
    Point(double x, double y);

  } Point;

  typedef struct BASELIBRARY_PUBLIC_FUNC Size
  {
    double width;
    double height;

    bool empty();

    Size();
    Size(double w, double h);

  } Size;

  /**
   * Four values describing the space on each side of an area.
   */
  typedef struct BASELIBRARY_PUBLIC_FUNC Padding
  {
    int left;
    int top;
    int right;
    int bottom;

    Padding(int padding);
    Padding(int left, int top, int right, int bottom);

  } Padding;

}
}

#endif /* _GEOMETRY_H_ */
