/*
 *  mdc_button.h
 *  mdcanvas
 *
 *  Created by Alfredo Kojima on 07/Apr/29.
 *  Copyright 2007 MySQL AB. All rights reserved.
 *
 */


#ifndef __MDC_BUTTON_H__
#define __MDC_BUTTON_H__


#include "mdc_icon_text.h"

BEGIN_MDC_DECLS

enum ButtonType {
  ActionButton,
  ToggleButton,
  ExpanderButton
};


class MYSQLCANVAS_PUBLIC_FUNC Button : public IconTextFigure {
public:
  Button(Layer *layer, ButtonType type);

  void set_active(bool flag);
  bool get_active();

  void set_image(cairo_surface_t *image);
  void set_alt_image(cairo_surface_t *image);

  virtual void draw_contents(CairoCtx *cr);
  virtual Size calc_min_size();
  
  sigc::signal<void> signal_activate() { return _action_signal; }

protected:
  ButtonType _button_type;
  bool _active;
  bool _pressed;
  bool _inside;
  
  cairo_surface_t *_image;
  cairo_surface_t *_alt_image;

  sigc::signal<void> _action_signal;

  virtual bool on_button_press(CanvasItem *target, const Point &point, MouseButton button, EventState state);
  virtual bool on_button_release(CanvasItem *target, const Point &point, MouseButton button, EventState state);
  virtual bool on_enter(CanvasItem *target, const Point &point);
  virtual bool on_leave(CanvasItem *target, const Point &point);
  virtual bool on_drag(CanvasItem *target, const Point &point, EventState state);
};
  
  
END_MDC_DECLS


#endif /* __MDC_BUTTON_H__ */
