/* 
 * (c) 2007-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef _MDC_CANVAS_VIEW_WINDOWS_H_
#define _MDC_CANVAS_VIEW_WINDOWS_H_

#include "mdc_canvas_view_opengl.h"

namespace mdc {


class MYSQLCANVAS_PUBLIC_FUNC WindowsGLCanvasView : public OpenGLCanvasView 
{
public:
  WindowsGLCanvasView(HWND window, int width, int height);
  virtual ~WindowsGLCanvasView();

  virtual bool initialize();

  virtual void make_current();
  virtual void remove_current();
  virtual void swap_buffers();

  virtual void update_view_size(int width, int height);

protected:
  HWND _window;
  HGLRC _glrc;
  HDC _hdc;
  DWORD _fps_timer;

  cairo_surface_t *_offline_surface;

  virtual void start_fps_timer() { _fps_timer= ::GetTickCount(); }
  virtual void stop_fps_timer_and_update_fps() { _fps= ((float)1000.0)/(::GetTickCount() - _fps_timer); }
};


class MYSQLCANVAS_PUBLIC_FUNC WindowsCanvasView : public CanvasView 
{
public:
  WindowsCanvasView(int width, int height);
  virtual ~WindowsCanvasView();

  virtual bool initialize();
  virtual bool has_gl() const { return false; }
  void set_target_context(HDC hdc);

protected:
  HDC _hdc;

  cairo_surface_t *_offline_surface;

  virtual void update_view_size(int width, int height);
  virtual void begin_repaint(int x, int y, int w, int h);
  virtual void end_repaint();
};

};


#pragma make_public(mdc::CanvasView)
#pragma make_public(mdc::EventState)
#pragma make_public(mdc::KeyInfo)

#endif /* _MDC_CANVAS_VIEW_WINDOWS_H_ */

