/*
 *  mdc_connector.h
 *  mdcanvas
 *
 *  Created by Alfredo Kojima on 07/May/2.
 *  Copyright 2007 MySQL AB. All rights reserved.
 *
 */

#ifndef __MDC_CONNECTOR_H__
#define __MDC_CONNECTOR_H__

#include "mdc_common.h"

BEGIN_MDC_DECLS

class Magnet;
class CanvasItem;

class MYSQLCANVAS_PUBLIC_FUNC Connector : public sigc::trackable
{
public:
  Connector(CanvasItem *owner);
  virtual ~Connector();

  void set_update_handler(const sigc::slot<void, Connector*> &update_handler);
  
  virtual bool try_connect(Magnet *magnet);
  virtual bool try_disconnect();
  
  virtual void connect(Magnet *magnet);
  virtual void disconnect();

  void set_draggable(bool flag);
  bool is_draggable() { return _draggable; }

  void set_tag(int tag) { _tag= tag; }
  int get_tag() { return _tag; }
  
  Magnet *get_connected_magnet() { return _magnet; }
  CanvasItem *get_connected_item();
  CanvasItem *get_owner() { return _owner; }

  Point get_position(const Point &srcpos);
  Point get_position();


  // callback for Magnet
  virtual void magnet_moved(Magnet *magnet);

protected:
  CanvasItem *_owner;
  Magnet *_magnet;
  int _tag;

  bool _draggable;
  
  sigc::slot<void, Connector*> _update_handler;
};


END_MDC_DECLS

#endif

