/*
 *  mdc_line_segment_handle.h
 *  mdcanvas
 *
 *  Created by Alfredo Kojima on 07/May/1.
 *  Copyright 2007 MySQL AB. All rights reserved.
 *
 */

#ifndef _MDC_LINE_SEGMENT_HANDLE_H_
#define _MDC_LINE_SEGMENT_HANDLE_H_

#include "mdc_item_handle.h"

BEGIN_MDC_DECLS

class MYSQLCANVAS_PUBLIC_FUNC LineSegmentHandle : public ItemHandle {
public:
  LineSegmentHandle(InteractionLayer *ilayer, CanvasItem *item, const Point &pos,
    bool vertical);
  virtual ~LineSegmentHandle();

  virtual mdc::Rect get_bounds() const;

  void set_vertical(bool flag);
  bool is_vertical() { return _vertical; }

private:
  bool _vertical;
};

END_MDC_DECLS

#endif
