/*
 *  mdc_magnet.h
 *  mdcanvas
 *
 *  Created by Alfredo Kojima on 07/May/2.
 *  Copyright 2007 MySQL AB. All rights reserved.
 *
 */


#ifndef __MDC_MAGNET_H__
#define __MDC_MAGNET_H__

#include "mdc_common.h"

BEGIN_MDC_DECLS

class Connector;
class CanvasItem;

class MYSQLCANVAS_PUBLIC_FUNC Magnet : public sigc::trackable
{
public:
  Magnet(CanvasItem *owner);
  virtual ~Magnet();

  virtual bool allows_connection(Connector *conn) const;
  virtual bool allows_disconnection(Connector *conn) const;

  void remove_all_connectors();

  virtual bool add_connector(Connector *conn);
  virtual void remove_connector(Connector *conn);

  virtual Point get_position_for_connector(Connector *conn, const Point &srcpos) const;
  virtual Point get_position() const;

  virtual double constrain_angle(double angle) const { return angle; }

  void set_connection_validator(const sigc::slot<bool, Connector*> &slot);
  void set_disconnection_validator(const sigc::slot<bool, Connector*> &slot);
  
  CanvasItem *get_owner() const { return _owner; }

protected:
  CanvasItem *_owner;

  std::list<Connector*> _connectors;

  sigc::slot<bool, Connector*> _connection_slot;
  sigc::slot<bool, Connector*> _disconnection_slot;

  virtual void notify_connected();

  virtual void owner_bounds_changed(const Rect &obounds);
  virtual void owner_parent_bounds_changed(CanvasItem *item, const Rect &obounds);
};


END_MDC_DECLS

#endif

