
#ifndef _MDC_STRAIGHT_LINE_LAYOUTER_H_
#define _MDC_STRAIGHT_LINE_LAYOUTER_H_



#include "mdc_line.h"

BEGIN_MDC_DECLS

class Connector;


// Just a straight line from starting point to the end.
class MYSQLCANVAS_PUBLIC_FUNC StraightLineLayouter : public LineLayouter
{
public:
  StraightLineLayouter(Connector *sconn, Connector *econn);
  virtual ~StraightLineLayouter();

  virtual Connector* get_start_connector() const { return _start_conn; }
  virtual Connector* get_end_connector() const { return _end_conn; }

  virtual std::vector<Point> get_points();
  virtual Point get_start_point();
  virtual Point get_end_point();

  virtual void update();

protected:
  Connector *_start_conn;
  Connector *_end_conn;

  Point _start;
  Point _end;

  virtual void connector_changed(Connector *conn);
};


#if 0
// A looping/cycle line
class MYSQLCANVAS_PUBLIC_FUNC LoopingLineLayouter : public LineLayouter
{
};
#endif


END_MDC_DECLS



#endif /* _MDC_STRAIGHT_LINE_LAYOUTER_H_ */
