/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "stdafx.h"

#include <mforms/checkbox.h>
#include <mforms/mforms.h>

using namespace mforms;

CheckBox::CheckBox()
{
  _checkbox_impl= &ControlFactory::get_instance()->_checkbox_impl;

  _checkbox_impl->create(this);
}


void CheckBox::set_active(bool flag)
{
  _updating= true;
  _checkbox_impl->set_active(this, flag);
  _updating= false;
}


bool CheckBox::get_active()
{
  return _checkbox_impl->get_active(this);
}

