//
//  MFContainerBase.m
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 10/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import "MFContainerBase.h"


@implementation MFContainerBase

//--------------------------------------------------------------------------------------------------

- (id)initWithFrame:(NSRect)frameRect
{
  self = [super initWithFrame: frameRect];
  if (self != nil)
    mBackColor = nil;
  return self;
}

//--------------------------------------------------------------------------------------------------

- (void)setPadding:(int)padding
{
  mPadding= padding;
}

//--------------------------------------------------------------------------------------------------

- (void)setTag:(NSInteger)tag
{
  mTag= tag;
}

//--------------------------------------------------------------------------------------------------

- (NSInteger)tag
{
  return mTag;
}

//--------------------------------------------------------------------------------------------------

- (void)setEnabled:(BOOL)flag
{
  for (id subview in [self subviews])
  {
    if ([subview respondsToSelector: @selector(setEnabled:)])
      [subview setEnabled: flag];
  }
}

//--------------------------------------------------------------------------------------------------

- (void)subviewMinimumSizeChanged
{
  NSSize minSize= [self preferredSize];
  NSSize size= [self frame].size;
  
  // size of some subview has changed, we check if our current size is enough
  // to fit it and if not, request forward the size change notification to superview
  
  if (mFreezeRelayout > 0)
    return;

  if (minSize.width != size.width || minSize.height != size.height)
  {
    if ([self superview])
    {
      [[self superview] subviewMinimumSizeChanged];
      return;
    }
    else
      [self setFrameSize: minSize];
  }
  [self resizeSubviewsWithOldSize:size];
}

//--------------------------------------------------------------------------------------------------

- (void)setFreezeRelayout:(BOOL)flag
{
  if (flag)
    mFreezeRelayout++;
  else
  {
    mFreezeRelayout--;
    if (mFreezeRelayout == 0)
    {
      [self subviewMinimumSizeChanged];
      [[self window] recalculateKeyViewLoop];
    }
  }
}

//--------------------------------------------------------------------------------------------------

- (void)setBackgroundColor: (NSColor*) color
{
  [mBackColor autorelease];
  mBackColor = [color retain];
  [self setNeedsDisplay: YES];
}

//--------------------------------------------------------------------------------------------------

/**
 * Fill the background of the container with the background color.
 */
- (void)drawRect: (NSRect) rect
{
  if (mBackColor != nil)
  {
    [mBackColor set];
    NSRectFill(rect);
  }
}

//--------------------------------------------------------------------------------------------------

- (void)setBackgroundImage: (NSString*) path withLayout: (mforms::ImageLayout) layout
{
  
}

//--------------------------------------------------------------------------------------------------

@end
