//
//  MFFileChooser.mm
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 8/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//


#import "MFFileChooser.h"

#import "MFView.h"
#include "mforms/mforms.h"


@implementation MFFileChooserImpl


- (id)initWithObject:(mforms::FileChooser*)chooser type:(mforms::FileChooserType)type
{
  self= [super init];
  if (self)
  {
    mOwner= chooser;
    mOwner->set_data(self);
    
    switch (type)
    {
      case mforms::OpenFile:
      {
        NSOpenPanel *panel= [[NSOpenPanel openPanel] retain];
        mPanel= panel;
        [panel setCanChooseDirectories:NO];
        [panel setCanChooseFiles:YES];
        break;
      }
      case mforms::SaveFile:
        mPanel= [[NSSavePanel savePanel] retain];
        [mPanel setCanCreateDirectories: YES];
        break;
      case mforms::OpenDirectory:
      {
        NSOpenPanel *panel= [[NSOpenPanel openPanel] retain];
        mPanel= panel;
        [panel setCanChooseDirectories:YES];
        [panel setCanChooseFiles:NO];
        break;
      }
    }
    [mPanel setAllowsOtherFileTypes:YES];
  }
  return self;
}


- (void) dealloc
{
  [mPanel release];
  [super dealloc];
}




static bool filechooser_create(mforms::FileChooser *self, mforms::FileChooserType type)
{
  [[[MFFileChooserImpl alloc] initWithObject:self type:type] autorelease];
  return true;
}


static void filechooser_set_title(mforms::FileChooser *self, const std::string &title)
{
  MFFileChooserImpl *chooser= self->get_data();
  if (chooser)
  {
    [chooser->mPanel setTitle: wrap_nsstring(title)];
  }
}


static bool filechooser_run_modal(mforms::FileChooser *self)
{
  MFFileChooserImpl *chooser= self->get_data();
  if (chooser)
  {
    if ([chooser->mPanel runModal] == NSFileHandlingPanelOKButton)
      return true;
  }
  return false;
}


static void filechooser_set_directory(mforms::FileChooser *self, const std::string &path)
{
  MFFileChooserImpl *chooser= self->get_data();
  if (chooser)
  {
    [chooser->mPanel setDirectory:wrap_nsstring(path)];
  }
}


static std::string filechooser_get_directory(mforms::FileChooser *self)
{
  MFFileChooserImpl *chooser= self->get_data();
  if (chooser)
  {
    return [[chooser->mPanel directory] UTF8String];
  }
  return "";
}


static std::string filechooser_get_path(mforms::FileChooser *self)
{
  MFFileChooserImpl *chooser= self->get_data();
  if (chooser)
  {
    return [[chooser->mPanel filename] UTF8String];
  }
  return "";
}


static void filechooser_set_extensions(mforms::FileChooser *self, const std::string &extensions, const std::string &default_extension)
{
  MFFileChooserImpl *chooser= self->get_data();
  if (chooser)
  {
    NSMutableArray *array= [NSMutableArray array];

    // extensions format:
    // AAA Files (*.aaa)|*.aaa|BBB Files (*.bbb)|*.bbb
    
    std::vector<std::pair<std::string, std::string> > extlist= self->split_extensions(extensions);
    
    for (std::vector<std::pair<std::string, std::string> >::const_iterator iter= extlist.begin();
      iter != extlist.end(); ++iter)
    {
      if (iter->second.size() > 2 || iter->second.substr(0, 2) == "*.")
        [array addObject: [NSString stringWithUTF8String: iter->second.substr(2).c_str()]];
      else if (iter->second[0] == '*')
        [array addObject: [NSString stringWithUTF8String: iter->second.substr(1).c_str()]];
    }

    if ([array count] > 0)
    {
      [chooser->mPanel setAllowedFileTypes: array];
    }
  }
}


void cf_filechooser_init()
{
  ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();
  
  f->_filechooser_impl.create= &filechooser_create;
  f->_filechooser_impl.set_title= &filechooser_set_title;
  f->_filechooser_impl.set_directory= &filechooser_set_directory;
  f->_filechooser_impl.get_directory= &filechooser_get_directory;
  f->_filechooser_impl.get_path= &filechooser_get_path;
  f->_filechooser_impl.run_modal= &filechooser_run_modal; 
  f->_filechooser_impl.set_extensions= &filechooser_set_extensions;
}


@end
