/* 
 * © 2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#import <Cocoa/Cocoa.h>

#import "MFContainerBase.h"
#include "mforms/table.h"


@interface MFTableImpl : MFContainerBase {
  mforms::Table *mOwner;
  float mRowSpacing;
  float mColumnSpacing;
  int mRowCount;
  int mColumnCount;
  BOOL mHomogeneous;
  

  NSMutableArray *mTableCells;
}


- (void)setRowSpacing:(float)spacing;
- (void)setColumnSpacing:(float)spacing;
- (void)setRowCount:(int)count;
- (void)setColumnCount:(int)count;

- (void)addSubview:(NSView*)view left:(int)left right:(int)right top:(int)top bottom:(int)bottom flags:(mforms::TableItemFlags)flags;

@end
