/* 
 *(c) 2009-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#import <Cocoa/Cocoa.h>

#include "MFBase.h"


/** MForms control implementations must subclass their own NS counterpart and implement the methods
 * below.  
 */
@interface NSView(MForms)

- (id)innerView;

- (void)subviewMinimumSizeChanged;
- (NSSize)minimumSize;
- (NSSize)minimumSizeForWidth:(float)width;
- (NSSize)preferredSize;
- (NSSize)preferredSizeForWidth:(float)width;

- (BOOL)widthIsFixed;
- (BOOL)heightIsFixed;

// Tag is used for internal purposes (special flags), do not use it for anything else
- (void)setTag:(NSInteger)tag;
@end

namespace mforms { class View; }
NSView *nsviewForView(mforms::View *view);
