/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA 02110-1301  USA
 */

#include "stdafx.h"

#include <mforms/code_editor.h>
#include <mforms/mforms.h>

using namespace mforms;

//--------------------------------------------------------------------------------------------------

CodeEditor::CodeEditor()
  : _updating(false)
{
  _code_editor_impl= &ControlFactory::get_instance()->_code_editor_impl;

  _code_editor_impl->create(this);
}

//--------------------------------------------------------------------------------------------------

void CodeEditor::set_text(const std::string& text)
{
  _updating = true;
  _code_editor_impl->set_text(this, text);
  _updating = false;
}

//--------------------------------------------------------------------------------------------------

const std::string CodeEditor::get_text(bool selection_only)
{
  return _code_editor_impl->get_text(this, selection_only);
}

//--------------------------------------------------------------------------------------------------

bool CodeEditor::has_selection()
{
  return _code_editor_impl->has_selection(this);
}

//--------------------------------------------------------------------------------------------------

void CodeEditor::clear_selection()
{
  _code_editor_impl->clear_selection(this);
}

//--------------------------------------------------------------------------------------------------

void CodeEditor::set_language(SyntaxHighlighterLanguage language)
{
  _code_editor_impl->set_language(this, language);
}

//--------------------------------------------------------------------------------------------------

void mforms::CodeEditor::set_read_only(bool flag)
{
  _code_editor_impl->set_read_only(this, flag);
}

//--------------------------------------------------------------------------------------------------

void CodeEditor::callback()
{
  if (!_updating)
    _signal_changed.emit();
}

//--------------------------------------------------------------------------------------------------
