/* 
 * © 2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _LF_DRAWBOX_H_
#define _LF_DRAWBOX_H_

#include "mforms/label.h"

#include "lf_view.h"

namespace mforms {
namespace gtk {

class DrawBoxImpl : public ViewImpl
{
protected:
  Gtk::EventBox *_darea;
  Glib::Dispatcher _repaint;
  int _fixed_width;
  int _fixed_height;
  
  virtual Gtk::Widget *get_outer() const { return _darea; }

  DrawBoxImpl(::mforms::DrawBox *self);
  bool repaint(GdkEventExpose *event, ::mforms::DrawBox *self);
  void mouse_cross_event(GdkEventCrossing *event, ::mforms::DrawBox *self);
  void mouse_button_event(GdkEventButton *event, ::mforms::DrawBox *self);
  void mouse_move_event(GdkEventMotion *event, ::mforms::DrawBox *self);
  static bool create(::mforms::DrawBox *self);
  static void set_needs_repaint(::mforms::DrawBox *self);

 public:
  static void init();

  virtual void set_size(int width, int height);
};

};
};


#endif /* _LF_DRAWBOX_H_ */
