/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _LF_LISTBOX_H_
#define _LF_LISTBOX_H_


#include "mforms/listbox.h"

#include "lf_view.h"

namespace mforms
{
namespace gtk
{

class ListBoxImpl : public ViewImpl
{
  class ComboColumn : public Gtk::TreeModel::ColumnRecord
  {
    public:
      ComboColumn()
      {
        add(_item);
      }
      Gtk::TreeModelColumn<Glib::ustring> _item;
  };

  Gtk::TreeView                 *_lbox;
  Gtk::ScrolledWindow           *_swin;

  ComboColumn                    _ccol;
  Glib::RefPtr<Gtk::ListStore>   _store;

  virtual Gtk::Widget *get_outer() const { return _swin; }
  virtual Gtk::Widget *get_inner() const { return _lbox; }

protected:
  ListBoxImpl(::mforms::ListBox *self, bool multi_select);
  static void selection_changed(::mforms::ListBox *self);
  static bool create(::mforms::ListBox *self, bool multi_select);
  static void clear(::mforms::ListBox *self);
  static int add_item(::mforms::ListBox *self, const std::string &item);
  static void add_items(::mforms::ListBox *self, const std::list<std::string> &items);
  static std::string get_text(::mforms::ListBox *self);
  static void set_index(::mforms::ListBox *self, int index);
  static int get_index(::mforms::ListBox *self);
  static void set_heading(ListBox *self, const std::string &text);
  static std::vector<int> get_selected_indices(ListBox *self);

 public:
  static void init();
};

}
}

#endif /* _LF_LISTBOX_H_ */
