/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _LF_TREEVIEW_H_
#define _LF_TREEVIEW_H_

#include <mforms/mforms.h>

#include "lf_view.h"

namespace mforms {
namespace gtk {


class TreeViewImpl : public ViewImpl
{
private:
  class ColumnRecord : public Gtk::TreeModelColumnRecord
  {
  public:
    std::vector<Gtk::TreeModelColumnBase*>  columns;
    Gtk::TreeModelColumn<Glib::ustring>     _tag_column;
    
    template<class C>
      const Gtk::TreeModelColumn<C> &get(int column)
      {
        Gtk::TreeModelColumnBase* c= columns[column];
        
        return *static_cast<Gtk::TreeModelColumn<C>*>(c);
      }

    virtual ~ColumnRecord();
    void add_tag_column();
    Gtk::TreeModelColumn<Glib::ustring>& tag_column();
    int add_string(Gtk::TreeView *tree, const std::string &title, bool editable);
    int add_integer(Gtk::TreeView *tree, const std::string &title, bool editable);
    int add_check(Gtk::TreeView *tree, const std::string &title, bool editable);
  };

  ColumnRecord _columns;
  

  Gtk::ScrolledWindow *_swin;
  Gtk::TreeView *_tree;
  sigc::connection _conn;

  Glib::RefPtr<Gtk::ListStore> _list_store;

  virtual Gtk::Widget *get_outer() const { return _swin; }
  virtual Gtk::Widget *get_inner() const { return _tree; }


  TreeViewImpl(TreeView *self, mforms::TreeOptions opts);
  void string_edited(const Glib::ustring &path, const Glib::ustring &new_text, int column);
  void toggle_edited(const Glib::ustring &path, int column);
  void on_activated(const Gtk::TreeModel::Path&, Gtk::TreeViewColumn*);
  void on_button_event(GdkEventButton *ev);

  int add_column(TreeColumnType type, const std::string &name, int initial_width, bool editable);
  void end_columns();
  static bool create(TreeView *self, mforms::TreeOptions opt);
  static int add_column(TreeView *self, TreeColumnType type, const std::string &name, int width, bool editable);
  static void end_columns(TreeView *self);
  static void clear_rows(TreeView *self);
  static void delete_row(TreeView *self, int row);
  static int add_row(TreeView *self);
  static int get_selected(TreeView *self);
  static void set_selected(TreeView* self, const int idx);
  static int count(TreeView *self);
  static void set_string(TreeView *self, int row, int column, const std::string &value);
  static void set_integer(TreeView *self, int row, int column, int value);
  static void set_check(TreeView *self, int row, int column, bool check);
  static std::string get_string(TreeView *self, int row, int column);
  static int get_int(TreeView *self, int row, int column);
  static bool get_check(TreeView *self, int row, int column);
  static std::string get_row_tag(TreeView *self, int row);
  static void set_row_tag(TreeView *self, int row, const std::string &value);

public:
  static void init();
};

  
}
}

#endif
