/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA 02110-1301  USA
 */

#ifndef _CODE_EDITOR_H_
#define _CODE_EDITOR_H_

#include <mforms/view.h>

/**
 * Provides a code editor with syntax highlighting for mforms.
 */

namespace mforms {

  class CodeEditor;

  enum SyntaxHighlighterLanguage {
    LanguageMySQL,
    LanguageCpp,
    LanguageLua,
    LanguagePython
  };

#ifndef DOXYGEN_SHOULD_SKIP_THIS
#ifndef SWIG
  struct CodeEditorImplPtrs
  {
    bool (__stdcall *create)(CodeEditor* self);
    void (__stdcall *set_text)(CodeEditor* self, const std::string& text);
    const std::string (__stdcall *get_text)(CodeEditor* self, bool selection_only);
    bool (__stdcall *has_selection)(CodeEditor* self);
    void (__stdcall *clear_selection)(CodeEditor* self);
    void (__stdcall *set_language)(CodeEditor* self, SyntaxHighlighterLanguage language);
    void (__stdcall *set_read_only)(CodeEditor* self, bool flag);
  };
#endif
#endif

  class MFORMS_EXPORT CodeEditor : public View
  {
  public:
    CodeEditor();

    /** Replaces the text in the editor. */
    void set_text(const std::string& text);
    void set_value(const std::string& text) { set_text(text); };

    /** Returns the text which is currently in the editor. If selection_only is true only the current
     *  selection is returned. If there is no selection then the result is an empty string in that case.
     */
    const std::string get_text(bool selection_only);
    virtual std::string get_string_value() { return get_text(false); };

    /** Returns true if there is currently a selection in the editor. */
    bool has_selection();

    /** Removes the selection if there is any. Text is not changed. */
    void clear_selection();

    /** Sets the language for the syntax highlighter. */
    void set_language(SyntaxHighlighterLanguage language);

    void set_read_only(bool flag);

    // Note: the interface is only temporary to make the Windows part working. It will be reworked
    //       to allow proper setup of the code editor using more of the native Scintilla features
    //       instead that of ScintillaNET.

#ifndef SWIG
    /** Signal emitted when contents are edited */
    sigc::signal<void> signal_changed() { return _signal_changed; }

#ifndef DOXYGEN_SHOULD_SKIP_THIS
    void callback();
#endif
#endif
  protected:
    CodeEditorImplPtrs* _code_editor_impl;
    bool _updating;

    sigc::signal<void> _signal_changed;
  };
};

#endif // _CODE_EDITOR_H_
