/* 
 * Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA 02110-1301  USA
 */
#ifndef _MFORMS_GRTTREEVIEW_H_
#define _MFORMS_GRTTREEVIEW_H_

#include <mforms/view.h>
#include <vector>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace bec {
  class TreeModel;
  struct NodeId;
};

namespace mforms {
  class GRTTreeView;
  
  enum GRTTreeColumnType
  {
    StringGRTColumnType,
    IconStringGRTColumnType,
    IntegerGRTColumnType,
    CheckGRTColumnType,
    IconGRTColumnType
  };

#ifndef SWIG
  struct GRTTreeViewImplPtrs
  {
    bool (__stdcall *create)(GRTTreeView *self, bool has_border);
    
    void (__stdcall *set_model)(GRTTreeView *self, bec::TreeModel *model);

    int (__stdcall *add_column)(GRTTreeView *self, GRTTreeColumnType type, int model_column, 
                                const std::string &name);

    int (__stdcall *add_column_editable)(GRTTreeView *self, GRTTreeColumnType type, int model_column, 
                                const std::string &name);
    
    void (__stdcall *set_column_width)(GRTTreeView *self, int model_column, int width);

    void (__stdcall *refresh)(GRTTreeView *self, const bec::NodeId &node);
    
    void (__stdcall *set_allow_multi_selection)(GRTTreeView *self, bool);
    bool (__stdcall *get_selected_node)(GRTTreeView *self, bec::NodeId &node);
    int (__stdcall *get_selection)(GRTTreeView *self, std::vector<bec::NodeId> &nodes);
    
    void (__stdcall *row_count_changed)(GRTTreeView *self, int old_count);
  };
#endif

  class MFORMS_EXPORT GRTTreeView : public View
  {
  public:
    GRTTreeView(bool border);
    
    void set_model(bec::TreeModel *model);
    void set_allow_multi_selection(bool flag);

    int add_column(GRTTreeColumnType type, int model_column, const std::string &name);
    int add_column_editable(GRTTreeColumnType type, int model_column, const std::string &name);
    
    void set_column_width(int model_column, int width);

    void refresh(const bec::NodeId &node); // call with bec::NodeId() for a full refresh
    void row_count_changed(int old_count);

    // can't return bec::NodeId because we cant include grt/tree_model.h from here
    bool get_selected_node(bec::NodeId &node);
    int get_selection(std::vector<bec::NodeId> &nodes);
    
#ifndef SWIG
    sigc::signal<void, bec::NodeId, int> signal_row_activate() { return _activate_signal; }
    sigc::signal<void>  signal_changed() {return _changed_signal;}

  public:
    void row_activate_callback(const bec::NodeId &node, int column);
    void changed();

#endif
  protected:
    GRTTreeViewImplPtrs *_grttreeview_impl;
    sigc::signal<void, bec::NodeId, int> _activate_signal;
    sigc::signal<void> _changed_signal;
  };
}

#endif // !DOXYGEN_SHOULD_SKIP_THIS
#endif /* _GRTTREEVIEW_H_ */
